import argparse
from PIL import Image


def aggregate(pdf: str, pngs: list):
    pngs_RGBA = [Image.open(png) for png in pngs]
    pngs_RGB = []
    for png in pngs_RGBA:
        background = Image.new("RGB", png.size, (255, 255, 255))
        png.load()
        background.paste(png, mask=png.split()[-1])
        pngs_RGB.append(background)
    pngs_RGB[0].save(pdf, "PDF", resolution=100.0, save_all=True,
                    append_images=pngs_RGB[1:])


if __name__ == '__main__':
    """ Aggregates multiple png's to one pdf """

    parser = argparse.ArgumentParser()
    parser.add_argument("pdf", type=str, help="full path to output dpf")
    parser.add_argument("pngs", type=str, help="png's to aggregate", nargs="+")
    args = parser.parse_args()

    aggregate(args.pdf, args.pngs)
