import argparse
from PyPDF2 import PdfMerger
import os


def aggregate(out_pdf: str, in_pdfs: list):
    merger = PdfMerger()
    for pdf in in_pdfs:
        bookmark = os.path.basename(pdf[:-4])
        merger.append(pdf, bookmark)
    merger.write(out_pdf)
    merger.close()


if __name__ == '__main__':
    """ Aggregates multiple pdf's to one pdf.  """

    parser = argparse.ArgumentParser()
    parser.add_argument("out_pdf", type=str, help="full path to output dpf")
    parser.add_argument("in_pdfs", type=str, help="pdf's to aggregate", nargs="+")
    args = parser.parse_args()

    aggregate(args.out_pdf, args.in_pdfs)
