import re
import pathlib
dgr_path = re.search("^(.*?/dgr)", str(pathlib.Path().resolve())).groups()[0]
from ogs6py import ogs
import os

val = "1e-4"
project = "tol_H_" + val
simulations = ["simT", "simTH", "simTHM"]
stages = ["init", "glacialcycle"]

for dim in ["2D"]:
    path = f"{dgr_path}/input/processes/{dim}/{project}/"
    os.makedirs(path, exist_ok=True)
    for sim in simulations:
        for stage in stages:
            template = f"{dgr_path}/input/processes/{dim}/{sim}_{stage}.prj"
            outfile = f"{path}/{sim}_{stage}.prj"
            model = ogs.OGS(INPUT_FILE=template, PROJECT_FILE=outfile)

            # add changes to the prj files
            alltols = {"T": "1e-2", "H":val, "M":"1e-6 1e-6"}
            xpath = "./time_loop/processes/process/convergence_criterion/abstols"
            value = " ".join([alltols[k] for k in alltols.keys() if k in sim])
            model.replace_text(value, xpath=xpath)

            model.write_input()