import pyvista as pv
import subprocess
from subdomains_from_2D_boundary import create_subdomains
from sys import argv, exit


def get_3D_boundaries_ops(in_mesh_file_name, out_boundary_path):
    directions = {"bottom": ('0', '0', '1'), "top": ('0', '0', '-1'),
                  "front": ('0', '1', '0'), "back": ('0', '-1', '0'),
                  "left": ('1', '0', '0'), "right": ('-1', '0', '0'), }
    names = [f'{out_boundary_path}/{name}.vtu' for name in directions.keys()]

    return [['ExtractSurface', '-i', in_mesh_file_name, '-o',
             f'{out_boundary_path}/{name}_surf.vtu', '-x', x, '-y', y, '-z', z, "-a", "20"]
            for name, (x, y, z) in directions.items()], names


def create(mesh, rank, subdomains_path):

    if rank < 3:
        create_subdomains(mesh, 30, subdomains_path, ["top_line", "bottom_line", "left_line", "right_line"])
        # bounds = pv.get_reader(mesh).read().bounds
        # print(bounds)
        # ops, _ = get_2D_boundaries_ops(mesh, [bounds[0], bounds[1]],
        #                                [bounds[2], bounds[3]], subdomains_path)
    else:
        ops, _ = get_3D_boundaries_ops(mesh, subdomains_path)
        for operation in ops:
            print(*operation, sep=" ")
            subprocess.call(operation, stdout=None)


if __name__ == '__main__':
    print("started generation boundaries")
    if len(argv) < 4:
        exit(1)

    mesh_filenamepath = argv[1]
    rank = int(argv[2])
    subdomains_path = argv[3]

    create(mesh_filenamepath, rank, subdomains_path)

