import lxml.etree as L_ET
from ogs6py import ogs


def row_to_xml_gen(template_filenames, attrib_df_key_pair=None, _xpath=None):
    def row_to_xml(row):
        # using OGS6py is easier here, since it autoreplaces the includes of
        # water.xml and ice.xml in the media xml which is what we want
        res_xml = ogs.OGS(INPUT_FILE=template_filenames[row.name],
                          PROJECT_FILE=template_filenames[row.name])
        if attrib_df_key_pair:
            res_xml._get_root().attrib[attrib_df_key_pair[0]] = \
                str(row[attrib_df_key_pair[1]])
        if _xpath:
            for i, col_name in enumerate(row.index):
                res_xml.replace_text(row.iloc[i], xpath=_xpath.format(col_name))
        return res_xml

    return row_to_xml


def get_xml_str(xml_tree, decl=True):
    L_ET.indent(xml_tree, space="    ")
    xml_string = L_ET.tostring(xml_tree.getroot(), encoding="ISO-8859-1",
                               xml_declaration=decl, pretty_print=True)
    return xml_string.decode('ascii')


def combine2file(xmls: list, file_out: str):
    with open(file_out, "w") as f:
        for xml in xmls:
            print(get_xml_str(xml.tree, xml==xmls[0]), file=f)


def aggregate_templates(param_df, templates, out_xml, x_path=None):
    if not type(templates) is list:
        templates = [templates] * param_df.shape[0]
    generator = row_to_xml_gen(templates, ("id", "layer_id"), x_path)
    xmls = list(param_df.apply(generator, axis=1))
    combine2file(xmls, out_xml)