# !/usr/bin/env python3

import vtk
from sys import argv, exit




def add_ID(input_file, output_file):
    print("Reading from", input_file)
    print("Writing to", output_file)

    r = vtk.vtkXMLUnstructuredGridReader()
    r.SetFileName(input_file)
    r.Update()

    m = r.GetOutput()

    cells = m.GetCells()

    MaterialIDs = vtk.vtkIntArray()
    MaterialIDs.SetNumberOfComponents(1)
    MaterialIDs.SetNumberOfTuples(m.GetNumberOfCells())
    MaterialIDs.SetName('MaterialIDs')
    for i in range(0, m.GetNumberOfCells()):
        MaterialIDs.SetValue(i, 0)

    cell_data = m.GetCellData()
    cell_data.AddArray(MaterialIDs)

    w = vtk.vtkXMLUnstructuredGridWriter()
    w.SetFileName(output_file)
    w.SetInputData(m)
    w.SetDataModeToAscii()
    w.SetCompressorTypeToNone()
    w.Update()





if __name__ == '__main__':
    if len(argv) < 3:
        print("Usage: " + argv[0] + " input.vtu output.vtu")
        exit(1)

    input_file = argv[1]
    output_file = argv[2]
    add_ID(input_file, output_file)

