# Installation on Windows 10 <!-- {docsify-ignore-all} -->

The installation procedure contains 3 parts:

1. [Installation of the Windows Subsystem for Linux (Ubuntu 20.04)](install_windows_wsl2.md)
2. [Installation of the OpenGeoSys DGR workflows on Ubuntu 20.04](install_linux_byscript.md) OR [manual](install_linux.md)  
3. [Preparing of the Windows Desktop environment (Shortcuts)](install_windows_shortcuts.md)

# OpenGeoSys DGR workflow on Windows 10 desktop

## Motivation

OpenGeoSys runs on Windows, Mac and Linux. While Windows is the most common operating system for desktops, High Performance Computing Centres typically run under Linux. 
The deep geological repository workflows are prepared for High Performance Computing and therefore to run under Linux. But with the Windows Subsystem for Linux (WSL) there is a convenient way to run OpenGeoSys workflow from a Windows desktop. From user perspective OpenGeoSys workflows behaves like as it would be installed as a typical Windows application.

## User - Overview for Windows 10 desktop

![WSL2 Concepts for OpenGeoSys DGR workflow](./figures/ogs_dgr_wsl2_concept.png "WSL2 Concepts for OpenGeoSys dgr workflow")

The light blue box represents the Windows 10 installation and the grey box the Linux Subsystem. Here you have access to all your files and programs (e.g. like Paraview). From here OpenGeoSys DGR workflows can be started like any other program. Also, you have access to all files OpenGeoSys may read or write via the folder "DGR". Files in the folder DGR are accessible from Windows and the Linux subsystem.

Through the shortcut "OpenGeoSys-workflows" OpenGeoSys is available via a command line interface. The difference to note is, that **the console runs a Linux bash instead of a Windows batch**. That's all.

![User experience Windows 10](./figures/winscreen.PNG "User experience Windows 10 OpenGeoSys dgr workflow")

## User - Overview for HPC

![HPC workflow architecture](./figures/ogs_dgr_wsl2_concept_hpc.png "HPC workflow architecture")

The grey box represents again the Linux installation, it hosts the same container as in the desktop example. As in the Windows 10 desktop the Linux part contains the copy of the git repository and a copy of the container. Just the file synchronization (represented by arrows) between the Linux part (HPC Center) and Windows desktop (or any other Mac or Linux desktop) will be replaced to SSH.


## Container Usage

All tools that are part of the workflow are part of the OpenGeoSys container (dark blue box). With the evolution of the workflow project this container can be easily replaced with newer versions. The same container is used on an HPC Center as in the Windows 10 desktop example above. Any Linux distribution can load this container and run the tools inside via Singularity and alternatively Docker. An update script will take care that the Version of the container corresponds to the version of the git repository. 





