# Installation on Linux | Mac

![Linux Installation Concept](./figures/ogs_dgr_concept_linux_desktop.png "Linux Installation Concept")

## 1. Git setup

### Setup git and gitlab account

To setup gitlab follow the same steps as describes [here](https://www.opengeosys.org/docs/devguide/development-workflows/gitlab/)


### Checkout 

Get a local copy of dgr repository from gitlab.opengeosys. 

#### For SSH
```
cd ~
git clone git@gitlab.opengeosys.org:ogs/uc-dgr/dgr.git
cd dgr
git checkout v0.3
```

or

#### For HTTPS
```
cd ~
git clone https://gitlab.opengeosys.org/ogs/uc-dgr/dgr.git
cd dgr
git checkout v0.3
```


### Developer git setup
If you want to contribute to the dgr git repository choose this option.

[Setup Git](install_linux_git_dgr_developer.md)


## 2. Singularity installation

Depending on you operating system there are these options available:  

- Windows Users with a Windows Subsystem Linux choose 2.1.
- Linux Users choose 2.2.
- Debian Users choose 2.2. OR 2.1.
- Mac Users choose 2.3.

### 2.1. Linux - Debian package ##

#### Install

```bash
wget http://ftp.us.debian.org/debian/pool/main/s/singularity-container/singularity-container_3.5.2+ds1-1_amd64.deb
sudo apt update
sudo apt install containernetworking-plugins squashfs-tools
sudo dpkg -i singularity-container_3.5.2+ds1-1_amd64.deb
```

Check if installation was successfull.
`singularity --version`

### 2.2. Linux - Build singularity ##

Follow the instruction in https://sylabs.io/guides/3.7/admin-guide/installation.html. or run 
the install script.

- Create a file or open a file with name `.bash_profile` in your home folder and append the location of the singularity binaries:
`PATH=$PATH:/opt/singularity/bin`

- Execute the created file, so that your active shell already knows the updated path.
`source ~/.bash_profile` 

### 2.3 Mac - Install singularity

### 2.4 Windows 
There is no direct Windows support. Installation of WSL2 is required. The option 2.1 can be chosen.

## 3. Container ##

There is a specific OpenGeoSys workflows - dgr - container. It is different from the OpenGeoSys container.

### User

[Simple setup](install_container_user.md)


### Developer
If you want to contribute to the container choose this option.

[Create, update und use Containers](install_container_developer.md)


## 4. Verification

Run the [first example](./2D-workflow/doc/getting_started.md)

