# Container creation

## 1. Using containers 

### 1.1 Change into the folder where the container_image will be stored.

```bash
cd <dgr>/container/images
```

### 1.2 Get the container image

Follow step 1.2.1 OR alternatively 1.2.2

#### 1.2.1 For release container with

```bash
singularity pull docker://registry.opengeosys.org/ogs/ogs/ogs-dgr:[tag]
```

- `[tag]` can be `v0.2`, `v0.3`


e.g. 
```bash
singularity pull docker://registry.opengeosys.org/ogs/ogs/ogs-dgr:v0.3
```

Alternatively:
`wget https://gitlab.opengeosys.org/ogs/container-maker/-/jobs/69247/artifacts/raw/_out/images/ogs-dgr.sif -O ogs-dgr_v0.3.sif`

#### 1.2.2 For latest container (only for testing)

Download container from a URL given to you e.g. 
`singularity pull docker://registry.opengeosys.org/ogs/ogs/ogs-dgr:latest`

To find a specific build you created by following steps in section2 "Creating containers" 
navigate to https://gitlab.opengeosys.org/ogs/container-maker/-/jobs/ , select job (click on passed), in job artefacts --> browse --> download file

It is recommended to put the .sif - file into <dgr>/container/images and name it "ogs-dgr_<TAG>.sif".
The TAG can be "v0.2", "v0.3", ...


### 1.3. Adapt your env.sh 

- Provide the location of the sif file with OGS_CONTAINER
- Enable Usage of container with USE_CONTAINER=1

The env.sh is located on `<dgr>/install/env.sh`

```bash
export OGS_CONTAINER=<dgr>/container/images/ogs-dgr_v0.3.sif
export USE_CONTAINER=1

```

## 2. Creating containers

- Run a manual pipeline on [ogs-container-maker](https://gitlab.opengeosys.org/ogs/container-maker/-/pipelines/new)
- Choose `project-dgr` as the branch name
- Optionally supply parameter, see the [README.md](https://gitlab.opengeosys.org/ogs/container-maker/-/blob/main/README.md) for details
![create container](./figures/install_linux_container_create.png)
- Click `Run Pipeline`
- Wait
- Once finished the container is available under the following link: [https://gitlab.opengeosys.org/ogs/container-maker/-/jobs/artifacts/project-dgr/raw/_out/images/ogs-dgr.sif?job=manual+build](https://gitlab.opengeosys.org/ogs/container-maker/-/jobs/artifacts/project-dgr/raw/_out/images/ogs-dgr.sif?job=manual+build)


## 3. Upload container for releases

### 3.1 Automatic

- On MergeRequest: builds Singularity image and tests functionality (TODO)
- On tag: Pushes image to ogs/ogs registry (ogs-dgr:[tag])
- On master: Pushes image to ogs/ogs registry (ogs-dgr:latest)

Containers are stored in the public ogs registry:
https://gitlab.opengeosys.org/ogs/ogs/container_registry/77

### 3.2 Manual
```bash
singularity remote login -u [username] oras://registry.opengeosys.org/v2 # Login needed just once, requires singularity >= 3.7
singularity push ogs-dgr.sif oras://registry.opengeosys.org/ogs/ogs/[name]:[tag]
```

- `[name]`: can be anything, proposed: `ogs-dgr`
- `[tag]` can be anything, e.g. `v0.1`, `v0.2`, ...

Images can be seen here: https://gitlab.opengeosys.org/ogs/ogs/container_registry

Please note that currently there is [an issue](https://gitlab.com/gitlab-org/gitlab/-/issues/324709) so you cannot see the tags.


# Archive

## Latest

```compiler.py ogs.py --pm system --ogs ogs/ogs@master --cmake_args ' -DOGS_CPU_ARCHITECTURE=sandybridge -DBUILD_TESTING=OFF' --sif_file ogs-dgr.sif --gui --packages dos2unix gmsh sed shapelib tofrodos vim --pip meshio snakemake vtk https://github.com/dominik-kern/msh2vtu/archive/main.zip```

### v0.2

```compiler.py ogs.py --pm system --ogs ogs/ogs@master --cmake_args ' -DOGS_CPU_ARCHITECTURE=sandybridge -DBUILD_TESTING=OFF' --sif_file ogs-dgr.sif --gui --packages dos2unix gmsh sed shapelib tofrodos vim --pip meshio snakemake vtk https://github.com/dominik-kern/msh2vtu/archive/v0.2.zip```

### v0.3

```compiler.py ogs.py --pm system --ogs ogs/ogs@v6.4.0 --cmake_args ' -DOGS_CPU_ARCHITECTURE=sandybridge -DBUILD_TESTING=OFF' --sif_file ogs-dgr.sif --gui --packages dos2unix gmsh sed shapelib tofrodos vim --pip meshio snakemake vtk https://github.com/dominik-kern/msh2vtu/archive/v0.2.zip```


### v0.4 candidate


```compiler.py ogs.py --pm system --ogs ogs/ogs@@081d95b85e394edf37debd189af48f7da7f6a739 --cmake_args ' -DOGS_CPU_ARCHITECTURE=sandybridge -DBUILD_TESTING=OFF' --sif_file og-dgr.sif --gui --packages dos2unix gmsh sed shapelib tofrodos vim --pip meshio snakemake vtk https://github.com/dominik-kern/msh2vtu/archive/v0.3.zip```

with DOGS_USE_MFRONT:
compiler.py ogs.py --pm system --ogs ogs/ogs@@081d95b85e394edf37debd189af48f7da7f6a739 --cmake_args ' -DOGS_CPU_ARCHITECTURE=sandybridge -DBUILD_TESTING=OFF -DOGS_USE_MFRONT=ON' --sif_file og-dgr.sif --gui --mfront --packages dos2unix gmsh sed shapelib tofrodos vim --pip meshio snakemake vtk https://github.com/dominik-kern/msh2vtu/archive/v0.3.zip

