import inspect, sys, os

if not hasattr(sys.modules[__name__], '__file__'):
    __file__ = inspect.getfile(inspect.currentframe())
prj_path = os.path.split(os.path.realpath(__file__))[0] + "/"

print("prj-path: ", prj_path, "\n" + "-" * 80)
print("python version: ", sys.version, "\n" + "-" * 80)
print("python path variables: ", sys.path, "\n" + "-" * 80)
print("path to python bin: ", os.path.dirname(sys.executable), "\n" + "-" * 80)

from glaciationBCs import pythonBCsOGS_AREHS as arehs
import pyvista as pv
import re

# ---------------------------------------------
# instantiate the BC objects used by OpenGeoSys
# ---------------------------------------------
# Naming convention:
# bc_Process_(external)origin_boundary_type(_coefficient)

# TODO: xyz -> uvw

reg = "/(\d)D/(.+)_(.+)-id_(\d+)-xres_(\d+\.?\d*)/.+/(sim.+)/"
dim, model, mesh_type, set_id, xres, process = re.search(reg, prj_path).groups()
dim = int(dim)
mesh_path = prj_path + "../mesh/"
bounds = pv.get_reader(mesh_path + "domain.vtu").read().bounds

if "T" in process:
    bc_T_glacier_above_Dirichlet = arehs.BCT_SurfaceTemperature(dim, bounds)
    bc_T_dgrepo_inside_VolSource = arehs.BCT_SourceFromRepository(dim, mesh_path + "repo.vtu") 
    bc_T_crustal_below_Neumann_y = arehs.BCT_BottomHeatFlux(dim, bounds)
    #bc_T_crustal_aside_Neumann_x = arehs.BCT_LateralHeatFlux(dim, bounds)
    bc_T_crustal_aside_Dirichlet = arehs.BCT_VerticalGradient(dim, bounds)
if "H" in process:
    bc_H_glacier_above_Dirichlet = arehs.BCH_SurfacePressure(dim, bounds)
    #bc_H_glacier_above_Neumann   = arehs.BCH_SurfaceInflux(dim, bounds)
    if dim == 3 and mesh_type == "prism":
        bc_H_crustal_south_Dirichlet = arehs.BCH_VerticalGradientFromInit(prj_path + "front_result.vtu")
        bc_H_crustal_north_Dirichlet_with_glacier = arehs.BCH_VerticalGradientExtendedFromInit(dim, bounds, prj_path + "back_result.vtu")
    elif dim == 3 and mesh_type == "toy":
        bc_H_crustal_south_Dirichlet = arehs.BCH_VerticalGradient(dim, bounds)
        bc_H_crustal_north_Dirichlet_with_glacier = arehs.BCH_VerticalGradientExtended(dim, bounds)
    else:
        local_bounds = list(bounds)
        mesh = pv.XMLUnstructuredGridReader(mesh_path + "left_line.vtu").read()
        local_bounds[3] = mesh.bounds[3]
        bc_H_crustal_south_Dirichlet = arehs.BCH_VerticalGradient(dim, local_bounds)
        mesh = pv.XMLUnstructuredGridReader(mesh_path + "right_line.vtu").read()
        local_bounds[3] = mesh.bounds[3]
        bc_H_crustal_north_Dirichlet_with_glacier = arehs.BCH_VerticalGradientExtended(dim, local_bounds)
if "M" in process:
    #bc_M_glacier_above_Neumann_x = arehs.BCM_SurfaceTraction_X(dim, bounds)
    bc_M_glacier_above_Neumann_y = arehs.BCM_SurfaceTraction_Y(dim, bounds)
    bc_M_crustal_aside_Dirichlet_x = arehs.BCM_LateralDisplacement_X(dim, bounds)
    bc_M_crustal_aside_Dirichlet_y = arehs.BCM_LateralDisplacement_Y(dim, bounds)
    #bc_M_crustal_below_Dirichlet_x = arehs.BCM_BottomDisplacement_X(dim, bounds)
    bc_M_crustal_below_Dirichlet_y = arehs.BCM_BottomDisplacement_Y(dim, bounds)
