import inspect, sys, os

if not hasattr(sys.modules[__name__], '__file__'):
    __file__ = inspect.getfile(inspect.currentframe())
path, _ = os.path.split(os.path.realpath(__file__))

print("prj-path: ", path, "\n" + "-" * 80)
print("python version: ", sys.version, "\n" + "-" * 80)
print("python path variables: ", sys.path, "\n" + "-" * 80)
print("path to python bin: ", os.path.dirname(sys.executable), "\n" + "-" * 80)

from glaciationBCs import pythonBCsOGS_AREHS as arehs
import pyvista as pv

# ---------------------------------------------
# instantiate the BC objects used by OpenGeoSys
# ---------------------------------------------
# Naming convention:
# bc_Process_(external)origin_boundary_type(_coefficient)

# TODO: xyz -> uvw

process = path.split("/sim")[1].split("/")[0]
dim=2
bounds = pv.get_reader(path + "/../mesh/domain.vtu").read().bounds

if "T" in process:
    bc_T_atmosph_above_Dirichlet = arehs.BCT_InitialTemperature()
    bc_T_crustal_below_Neumann_y = arehs.BCT_BottomHeatFlux(dim, bounds)
if "H" in process:
    bc_H_atmosph_above_Dirichlet = arehs.BCH_InitialPressure()
    bc_H_crustal_aside_Dirichlet = arehs.BCH_VerticalGradient(dim, bounds)
if "M" in process:
    bc_M_crustal_aside_Dirichlet_x = arehs.BCM_LateralDisplacement_X(dim, bounds)
    bc_M_crustal_aside_Dirichlet_y = arehs.BCM_LateralDisplacement_Y(dim, bounds)
    bc_M_crustal_below_Dirichlet_y = arehs.BCM_BottomDisplacement_Y(dim, bounds)
