#!/usr/bin/bash

# ================ VARIABLES ===================
# for linear (1) or quadratic (2) meshes
ELEM_ORDER=$1

echo "The element order is $ELEM_ORDER"
# ================ MESH NAMES ===================
DOMAIN="ys_domain_appended_cell_data.vtu"
TOP="ys_physical_group_top.vtu"
BOTTOM="ys_physical_group_bottom.vtu"
EAST="ys_physical_group_east.vtu"
WEST="ys_physical_group_west.vtu"
NORTH="ys_physical_group_north.vtu"
SOUTH="ys_physical_group_south.vtu"

python3.9 pv_stretched_mesh.py  # output:   tmp_linear_hex.vtu

if [ "$1" = "1" ]; then
	NodeReordering -i tmp_linear_hex.vtu -o tmp_linear_hex_reordered.vtu -m 3
	
	ExtractSurface -i tmp_linear_hex_reordered.vtu -o $TOP -x 0 -y 0 -z -1 -a 80
	ExtractSurface -i tmp_linear_hex_reordered.vtu -o $BOTTOM -x 0 -y 0 -z 1 -a 1
	ExtractSurface -i tmp_linear_hex_reordered.vtu -o $NORTH -x 0 -y -1 -z 0 -a 1 
	ExtractSurface -i tmp_linear_hex_reordered.vtu -o $SOUTH -x 0 -y 1 -z 0 -a 1 
	ExtractSurface -i tmp_linear_hex_reordered.vtu -o $EAST -x -1 -y 0 -z 0 -a 1 
	ExtractSurface -i tmp_linear_hex_reordered.vtu -o $WEST -x 1 -y 0 -z 0 -a 1
	
	identifySubdomains -m tmp_linear_hex_reordered.vtu -f $TOP $BOTTOM $NORTH $SOUTH $EAST $WEST

	python3.9 appendCellData.py tmp_linear_hex_reordered.vtu $DOMAIN
	
else
	createQuadraticMesh -i tmp_linear_hex.vtu -o tmp_quad_hex.vtu
	NodeReordering -i tmp_quad_hex.vtu -o tmp_quad_hex_reordered.vtu -m 3

	ExtractSurface -i tmp_quad_hex_reordered.vtu -o tmp_physical_group_top_linear.vtu -x 0 -y 0 -z -1 -a 80
	ExtractSurface -i tmp_quad_hex_reordered.vtu -o tmp_physical_group_bottom_linear.vtu -x 0 -y 0 -z 1 -a 1
	ExtractSurface -i tmp_quad_hex_reordered.vtu -o tmp_physical_group_north_linear.vtu -x 0 -y -1 -z 0 -a 1 
	ExtractSurface -i tmp_quad_hex_reordered.vtu -o tmp_physical_group_south_linear.vtu -x 0 -y 1 -z 0 -a 1 
	ExtractSurface -i tmp_quad_hex_reordered.vtu -o tmp_physical_group_east_linear.vtu -x -1 -y 0 -z 0 -a 1 
	ExtractSurface -i tmp_quad_hex_reordered.vtu -o tmp_physical_group_west_linear.vtu -x 1 -y 0 -z 0 -a 1 

	createQuadraticMesh -i tmp_physical_group_top_linear.vtu    -o $TOP
	createQuadraticMesh -i tmp_physical_group_bottom_linear.vtu -o $BOTTOM
	createQuadraticMesh -i tmp_physical_group_north_linear.vtu  -o $NORTH
	createQuadraticMesh -i tmp_physical_group_south_linear.vtu  -o $SOUTH
	createQuadraticMesh -i tmp_physical_group_east_linear.vtu   -o $EAST
	createQuadraticMesh -i tmp_physical_group_west_linear.vtu   -o $WEST

	identifySubdomains -m tmp_quad_hex_reordered.vtu -f $TOP $BOTTOM $NORTH $SOUTH $EAST $WEST

	python3.9 appendCellData.py tmp_quad_hex_reordered.vtu $DOMAIN		
fi


rm tmp_*
