'''
stretch structured mesh to match a given surface

Dominik Kern
'''
#import sys
import meshio
import numpy as np
import pyvista as pv
#from PVGeo.grids import SurferGridReader
#import cmocean

def mesh2D(x,y):
    LX = max(x) - min (x)
    LY = max(y) - min (y)
    xc = np.mean(x)
    yc = np.mean(y)
    
    L = (LX+LY)/2
    x2, y2 = np.meshgrid(x, y)
    r = np.sqrt( (x2-xc) ** 2 + (y2-yc) ** 2)
    z2 = 100*np.cos(2*np.pi*r/L)
    grid = pv.StructuredGrid(x2, y2, z2)   # 2D
    
    return grid

def mesh3D(top_mesh, x, y, z_scale):
    xs, ys, zs = np.meshgrid(x, y, z_scale) 
    z_depth = 1000.0
    top_mesh_z = np.reshape(top_mesh.z, (len(y), len(x))) + z_depth   # to stretch total length
    for z_index, z_factor in enumerate(z_scale):
        zs[:,:,z_index] = z_factor*top_mesh_z
    zs = zs - z_depth   # set back to N.N.
    return pv.StructuredGrid(xs, ys, zs)   # 3D


# subdomain for tests
nx=10
ny=10
nz=5

x = np.linspace(0, 1500.0, num=nx+1)  # num nodes
y = np.linspace(0, 1500.0, num=ny+1)  # num nodes
top_mesh = mesh2D(x,y)
#top_mesh.plot(show_edges=True)
z_scale = np.linspace(1.0, 0, nz+1)   # scale factor between top (1) and bottom (0) in N levels, i.e. N-1 layers
domain_mesh = mesh3D(top_mesh, x, y, z_scale)
#domain_mesh.plot(show_edges=True)

pv.save_meshio("tmp_linear_hex.vtu", domain_mesh) 
