#!/usr/bin/bash

# ================ VARIABLES ===================
# for linear (1) or quadratic (2) meshes
ELEM_ORDER=$1

echo "The element order is $ELEM_ORDER"
# ================ MESH NAMES ===================
ORIGIN="Ton-Nord"

TOP=top
BOTTOM=bottom
EAST=east
WEST=west
NORTH=north
SOUTH=south

eps=1
#300x375x50

#_400_400_40
TOP_z=$(expr -10 - $eps)
BOT_z=$(expr -3680 + $eps)
EAST_x=$(expr 19000 - $eps)
WEST_x=$(expr  9000 + $eps)
NORTH_y=$(expr 21200 - $eps)
SOUTH_y=$(expr  8800 + $eps)



#_500_500_250
TOP_z=$(expr -64 - $eps)
BOT_z=$(expr -3689 + $eps)
EAST_x=$(expr 19000 - $eps)
WEST_x=$(expr  9000 + $eps)
NORTH_y=$(expr 21250 - $eps)
SOUTH_y=$(expr  8750 + $eps)

#_200_200_50
TOP_z=$(expr 11 - $eps)
BOT_z=$(expr -3689 + $eps)
EAST_x=$(expr 18900 - $eps)
WEST_x=$(expr  9100 + $eps)
NORTH_y=$(expr 21100 - $eps)
SOUTH_y=$(expr  8900 + $eps)

#_400_400_40
TOP_z=$(expr -10 - $eps)
BOT_z=$(expr -3680 + $eps)
EAST_x=$(expr 19000 - $eps)
WEST_x=$(expr  9000 + $eps)
NORTH_y=$(expr 21200 - $eps)
SOUTH_y=$(expr  8800 + $eps)

#TODO: use grid.GetBounds() !

echo checkMesh -p -v ${ORIGIN}.vtu
checkMesh -p -v ${ORIGIN}.vtu

if [ "$2" = 1 ]; then
	echo reviseMesh -i ${ORIGIN}.vtu -o domain.vtu
	reviseMesh -i ${ORIGIN}.vtu -o domain.vtu
	NodeReordering -i domain.vtu -o domain.vtu -m 3
else
	cp ${ORIGIN}.vtu domain.vtu
fi

if [ "$1" = "1" ]; then
	ExtractBoundary -i domain.vtu -o boundary.vtu
	
	#Divide into different boundary meshes
	removeMeshElements -i boundary.vtu -o ${TOP}.vtu --z-max $TOP_z
	removeMeshElements -i boundary.vtu -o ${BOTTOM}.vtu --z-min $BOT_z
	removeMeshElements -i boundary.vtu -o ${NORTH}.vtu --y-max $NORTH_y
	removeMeshElements -i boundary.vtu -o ${SOUTH}.vtu --y-min $SOUTH_y
	removeMeshElements -i boundary.vtu -o ${EAST}.vtu --x-max $EAST_x
	removeMeshElements -i boundary.vtu -o ${WEST}.vtu --x-min $WEST_x
		
	identifySubdomains -m domain.vtu -f ${TOP}.vtu ${BOTTOM}.vtu ${NORTH}.vtu ${SOUTH}.vtu ${EAST}.vtu ${WEST}.vtu
	
	#python3 recreate_top_bottom.py Ton-Nord_top.vtu linear
	#python3 recreate_top_bottom.py Ton-Nord_bottom.vtu linear
	
elif [ "$1" = "2" ]; then
	createQuadraticMesh -i domain.vtu -o domain_quad.vtu
	NodeReordering -i domain_quad.vtu -o domain_quad.vtu -m 3	
	ExtractBoundary -i domain_quad.vtu -o boundary_quad.vtu
	
	#Divide into different boundary meshes
	removeMeshElements -i boundary_quad.vtu -o ${TOP}_quad.vtu --z-max $TOP_z
	removeMeshElements -i boundary_quad.vtu -o ${BOTTOM}_quad.vtu --z-min $BOT_z
	removeMeshElements -i boundary_quad.vtu -o ${NORTH}_quad.vtu --y-max $NORTH_y
	removeMeshElements -i boundary_quad.vtu -o ${SOUTH}_quad.vtu --y-min $SOUTH_y
	removeMeshElements -i boundary_quad.vtu -o ${EAST}_quad.vtu --x-max $EAST_x
	removeMeshElements -i boundary_quad.vtu -o ${WEST}_quad.vtu --x-min $WEST_x

	identifySubdomains -m domain_quad.vtu -f ${TOP}_quad.vtu ${BOTTOM}_quad.vtu ${NORTH}_quad.vtu ${SOUTH}_quad.vtu ${EAST}_quad.vtu ${WEST}_quad.vtu
	
	#python3 recreate_top_bottom.py Ton-Nord_top.vtu quadratic
	#python3 recreate_top_bottom.py Ton-Nord_bottom.vtu quadratic

else
	echo "The element order $ELEM_ORDER is not available"
fi

