import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import math


plt.rcParams['font.weight'] = 'normal'
plt.rcParams['font.family'] = 'serif'
plt.rcParams['axes.labelsize'] = 'small'
plt.rcParams['legend.fontsize'] = 'small'
plt.rcParams['xtick.labelsize'] = 'small'
plt.rcParams['ytick.labelsize'] = 'small'
plt.rcParams['legend.framealpha'] = 1
plt.rcParams['lines.markersize'] = 5
plt.rcParams['axes.grid'] = True
plt.rcParams['figure.dpi'] = 300


def formatGrid(ax):
    ax.grid(which='major', color='lightgrey', linestyle='-')
    ax.grid(which='minor', color='0.95', linestyle='--')  
    ax.minorticks_on()


p = ['p1', 'p2', 'p3']
titles = [r'$x = 0m, y = -300m$', r'$x = 3250m, y = -300m$', r'$x = 5500m, y = -300m$']
biot = ['Young_10k0_', 'Young_15k6_', 'Young_20k0_']

for p_i, title_i in zip(p, titles):
    fig, ax = plt.subplots(1, 1, figsize=(4, 4))
    ax.set_xlabel(r"Zeit [a]")
    ax.set_ylabel(r"Hebung | Senkung [m]")
    for b_i in biot:
        filename = b_i + p_i + '.csv'
        print(filename)
        df = pd.read_csv(filename) 
        df = df.loc[df["Time"] >= 10000]
        df = df.loc[df["Time"] <= 11600]
        uy = df["avg(displacement (1))"].to_numpy()
        uy = uy - uy[0]
        t = df["Time"]
        t = t - 10000
        ax.plot(t, uy, "-")

    formatGrid(ax)
    ax.legend([r'$E = 10 MPa$', r'$E = 15.6 MPa$', r'$E = 20 MPa$'])
    ax.set_xlim([0,1600])
    ax.set_title(title_i)
    fig.tight_layout(pad=0)
    fig.savefig("HM_MIL_Young_parameter_study_" + p_i + ".png", format='png')


#ax.legend([r"a = 5 cm, e0 = 4e-5, K = 3 GPa"])
