from paraview.simple import *

arehssaltHM_moving_ice_load_Biotpvd = PVDReader(registrationName='Biot', FileName='arehs-salt-HM_moving_ice_load_Young_high.pvd')
arehssaltHM_moving_ice_load_Biotpvd.CellArrays = []
arehssaltHM_moving_ice_load_Biotpvd.PointArrays = ['displacement']

extractLocation1 = ExtractLocation(registrationName='ExtractLocation1', Input=arehssaltHM_moving_ice_load_Biotpvd)
extractLocation1.Mode = 'Interpolate At Location'
extractLocation1.Location = [0.0, -300.0, 0.0]

plotDataOverTime1 = PlotDataOverTime(registrationName='PlotDataOverTime1', Input=extractLocation1)

SaveData('Young_20k0_p1.csv', proxy=plotDataOverTime1, ChooseArraysToWrite=1,
    RowDataArrays=['Time', 'avg(displacement (1))'],
    UseScientificNotation=1,
    FieldAssociation='Row Data',
    AddTime=1)

extractLocation1.Location = [3250.0, -300.0, 0.0]
UpdatePipeline(time=0.0, proxy=arehssaltHM_moving_ice_load_Biotpvd)
SaveData('Young_20k0_p2.csv', proxy=plotDataOverTime1, ChooseArraysToWrite=1,
    RowDataArrays=['Time', 'avg(displacement (1))'],
    UseScientificNotation=1,
    FieldAssociation='Row Data',
    AddTime=1)

extractLocation1.Location = [5500.0, -300.0, 0.0]
UpdatePipeline(time=0.0, proxy=arehssaltHM_moving_ice_load_Biotpvd)
SaveData('Young_20k0_p3.csv', proxy=plotDataOverTime1, ChooseArraysToWrite=1,
    RowDataArrays=['Time', 'avg(displacement (1))'],
    UseScientificNotation=1,
    FieldAssociation='Row Data',
    AddTime=1)
