# JUWELS SSH 

For further details see: https://apps.fz-juelich.de/jsc/hps/juwels/access.html

1. Login into https://judoor.fz-juelich.de/login and add your private ssh key to JUWELS
2. For container usage (apptainer) "Agree" on "Access to other restricted software" section "Container Runtime Engine"
   (https://judoor.fz-juelich.de/account/a/JSC_LDAP/meisel1/software)
3. Login via SSH into JUWELS frontend
   ` ssh -i ~/.ssh/<your_private_key> <your_user_name> @juwels.fz-juelich.de`


# JUWELS frontend preparation

1. create a user directory in the common project folder `/p/project/ogs6hpc4/<your name>` , from now on refered as `<user_dir>`
2. clone dgr repository `git clone https://gitlab.opengeosys.org/ogs/uc-dgr/dgr.git` into `<user_dir>`, from now on refered as `<dgr>`
3. change into directory `<dgr>/container/images` and pull the latest container with 
   `apptainer pull docker://registry.opengeosys.org/ogs/ogs/ogs-dgr:latest`
4. load Python module : `module load Python`

5. create a virtual python environment, from `<user_dir>` do
   ```
   mkdir venvs
   virtualenv venvs/arehs_py39
   ```
6. activate the virtual python environment `source <user_dir>venvs/arehs_py39/bin/activate`
7. a) pip install -r `<dgr>/envs/requirements.txt`
   b) skip 5-6, pip install --user -r `<dgr>/envs/requirements.txt`
8. change into `<dgr>` and test `snakemake --profile profiles/juwels results/sim/2D/model_Ton-Nord_toy-id_6-xres_405-factor_1/simT/init/parts_4/OGSoutput.pvd` 

# On every login
1. load Python module : `module load X11/20210802 Python Jupyter`
2. optional: activate the virtual python environment `source <user_dir>venvs/arehs_py39/bin/activate`
3. optional: define alias `alias sm='python -m snakemake --profile profiles/juwels`


# Workaround (container not functional on juwels)
1. module load GCC ParaStationMPI Python Eigen PETSc Boost git Ninja/1.10.2 HDF
2. export PYTHONPATH=/p/project/ogs6hpc4/dgr/glaciationBCs/src
3. export PATH=/p/project/ogs6hpc4/dgr/o/build/rp_arehs5/bin:$PATH



   


