# Use-Case Deep Geological Repository <!-- {docsify-ignore-all} -->
The Use-Case Deep Geological Repository (DGR) shall demonstrate the functioning of OGS-6 workflows for geotechnical applications in the field of nuclear waste deposition for various types of host rocks, i.e. clay, salt, and crystalline rocks.

<img src="2D-workflow/manual-workflow/figures/rainfall_transient_wo_gravitation.png"  width="75%">


# Getting started - User Guides
## Installation

- [Windows 10](install/doc/install_windows.md) | [Linux | Mac](install/doc/install_linux.md) 

## Update
- [Update](install/doc/update_linux.md) (same for all platforms - Windows | Linux | Mac)

## Examples
- [First example](2D-workflow/doc/getting_started.md)
- [Further examples](2D-workflow/doc/examples.md)


# Contribute - Developer Guides

## Setup dgr

- [Setup](install/doc/install_linux_git_dgr_developer.md) to contribute the this git repository.

## Container for the dgr workflow
- Container: Create, Update and release [containers](install/doc/install_container_developer.md).
- Tests: Add and update [tests](doc/tests.md)
- Postprocessing: [Time-Analysis](doc/analysis.md)

### Workflow details
- [Installation JUWELS](doc/install_juwels.md)



### 3D-workflow details (deprecated)
- [Documentation of 3D workflow](3D-workflow/doc/overview.md)
- [Meshing strategies](3D-workflow/doc/meshing.md)
- [Performance benchmarks](3D-workflow/doc/performance.md)


### 2D-workflow details (deprecated)

- [Documentation of manual 2D workflow](2D-workflow/manual-workflow/README.md)
- [Project templates ( H | HM ) problem](2D-workflow/manual-workflow/project-template)

# Links
## Documentation
[Gitlab uc-dgr](https://gitlab.opengeosys.org/ogs/uc-dgr/dgr) | [Overleaf-Entwicklungsplanung](https://www.overleaf.com/project/6042d9c057a4e91ce91eb191) | [Overleaf-Fortschrittsbericht](https://www.overleaf.com/project/601cf751130d22dd456ccd9a) | [UFZ cloud](https://nc.ufz.de/s/E9zoaP4LjD4nAb5/authenticate/showShare) | [UFZ website](https://www.ufz.de/index.php?en=47155) | [Mendeley](https://www.mendeley.com/community/arhes/) | [UFZ-Cloud-Zwischenbericht](https://nc.ufz.de/apps/onlyoffice/s/E9zoaP4LjD4nAb5?fileId=131275457)|[OneDrive-Zwischenbericht presentation](https://onedrive.live.com/view.aspx?resid=F06F1B0139956CAB!3560&ithint=file%2cpptx&authkey=!AIEwkX0AfmqG36A) | [OGS Jupyter Lab](https://github.com/OlafKolditz/ogs-jupyter-lab) | [Report - overleaf](https://www.overleaf.com/project/601cf751130d22dd456ccd9a) 

- In progress: [Final report - Onedrive Word](https://onedrive.live.com/edit.aspx?resid=F06F1B0139956CAB!14867&ithint=file%2cdocx&authkey=!AOGIUCVK5oWVm0E)

## Presentations

- 07.04.22 https://onedrive.live.com/edit.aspx?resid=F06F1B0139956CAB!13919&ithint=file%2cpptx&authkey=!AK2gLcBj-r7NGt0
- 14.11.22 https://onedrive.live.com/edit.aspx?resid=F06F1B0139956CAB!14739&ithint=file%2cpptx&authkey=!ACgBY2-JhztN7WA
## Communication
- Jour Fixe - Each Wednesday 14:30 - 15:30  : [DFN Room](https://conf.dfn.de/webapp/conference/979159652), [BBB Room](https://ufz.collocall.de/b/tob-ywb-com-p9p)
- [Mattermost](https://mattermost.opengeosys.org/ogs-devs/channels/workflowogs_2d)





