# 3D workflows
## Overview

```mermaid
graph TD;
  LAYER_SELECTION-->DOMAIN_MESH;
  GOCAD_MODEL-->VTU_LAYERS;
  VTU_LAYERS-->DOMAIN_MESH;
  MATERIAL_LIST-->PRJ_FILE;
  LAYER_SELECTION-->PRJ_FILE;
  PRJ_FILE-->SIMULATION_RESULTS;
  DOMAIN_MESH-->SIMULATION_RESULTS;
  DOMAIN_MESH-->BOUNDARY_MESHES;
  BOUNDARY_MESHES-->SIMULATION_RESULTS;
```
```mermaid
graph TD;
  3D_DOMAIN_MESH--3D-->3D_BOUNDARY_MESHES;
  VTU_LAYERS--3D-->3D_DOMAIN_MESH;
  ORDERED_LAYER_LIST-->2D_VERTICAL_SLICE;
  MATERIAL_LIST-->ORDERED_LAYER_LIST;
  GOCAD_MODEL-->VTU_LAYERS;
  VTU_LAYERS-->2D_VERTICAL_SLICE;
  2D_VERTICAL_SLICE-->2D_DOMAIN_MESH;
  2D_DOMAIN_MESH-->2D_BOUNDARY_MESH;
  2D_BOUNDARY_MESH-->2D_BOUNDARY_MESHES;
  2D_TEMPLATE_PRJ-->2D_PRJ_FILE;
  MATERIAL_LIST-->2D_PRJ_FILE;
  2D_PRJ_FILE-->2D_SIMULATION_RESULTS;
  2D_DOMAIN_MESH-->2D_SIMULATION_RESULTS;
  2D_BOUNDARY_MESHES-->2D_SIMULATION_RESULTS;
  2D_SIMULATION_RESULTS-->VERIFICATION;
  2D_SIMULATION_RESULTS-->VISUALIZATION;
  REFERENCE_RESULTS-->VERIFICATION;
  2D_SIMULATION_RESULTS--3D-->3D_BOUNDARY_MESHES;
  3D_DOMAIN_MESH--3D-->3D_SIMULATION_RESULTS;
  3D_DOMAIN_MESH--3D-->3D_BOUNDARY_MESHES;
  REFERENCE_RESULTS-->3D_SIMULATION_RESULTS
  style 3D_BOUNDARY_MESHES fill:#f9f,stroke:#333,stroke-width:4px
  3D_BOUNDARY_MESHES--3D-->3D_SIMULATION_RESULTS;
  3D_PRJ_FILE-->3D_SIMULATION_RESULTS;
  3D_SIMULATION_RESULTS-->VISUALIZATION[Visualization and reports];
  MATERIAL_LIST--3D-->3D_PRJ_FILE;
  JUPYTER_NOTEBOOKS-->VISUALIZATION;
```

  
  [Click here if mermaid broken)](./mermaid.jpg "Diagram")




| Step     | Description                | Tool     | Example Input | Example Output | OutputScreenshot |  Example Command | Open Issues |
| ---      |  ------------------------  |----------|---------------|----------------|------------------|------------------|-------|
| 1  | Convert GOCAD (TSurface) file into multiple triangulated meshes in VTU format, each mesh represents one layer boundary in 2D, i.e. the top surface plus the lower boundary of each stratigraphic unit | [GocadTSurfaceReader](https://www.opengeosys.org/docs/tools/fileio/gocadtsurfacereader/) | [GOCAD - TSurface](../master/input/models/2021-02-08_Strukturmodell_ts_irev02/Basisflaechen_Ton_Nord.ts) | Three out of 18 files shown here: [00_KB.vtu](./example-files/output/00_KB.vtu), [09_jo.vtu](./example-files/output/09_jo.vtu),[17_z.vtu](./example-files/output/17_z.vtu) | ![Screenshot Paraview - VTU with 3 selected layer boundaries and associated MaterialIDs](./figures/ExtractMaterials.png "Screenshot Paraview - VTU with 3 of 18 selected layer boundaries and associated MaterialIDs") | `GocadTSurfaceReader -i Basisflaechen_Ton_Nord.ts -o OGS_Ton_Nord` |[Read under Linux](https://gitlab.opengeosys.org/ogs/uc-dgr/dgr/-/issues/6)|
