# Manual workflows
## Overview

All steps described here are part of the [2D_workflow.sh](./2D_workflow.sh) script. Get started with [this examples](../doc/examples.md) .

![Screenshot Paraview - Rainfall without gravitation](./figures/rainfall_transient_wo_gravitation.png "Screenshot Paraview - Rainfall without gravitation")

```mermaid
graph TD;
  GOCAD_MODEL-->VERTICAL_SLICE;
  ORDERED_LAYER_LIST-->VERTICAL_SLICE;
  MATERIAL_LIST-->ORDERED_LAYER_LIST;
  VERTICAL_SLICE-->DOMAIN_MESH;
  DOMAIN_MESH-->BOUNDARY_MESH;
  BOUNDARY_MESH-->BOUNDARY_MESHES;
  MATERIAL_LIST-->PRJ_FILE;
  PRJ_FILE-->SIMULATION_RESULTS;
  DOMAIN_MESH-->SIMULATION_RESULTS;
  BOUNDARY_MESHES-->SIMULATION_RESULTS;
  TECPLOT_MESH-->DOMAIN_MESH;
```

## GOCAD (TSurface)

| Step     | Description                | Tool     | Example Input | Example Output | OutputScreenshot |  Example Command | Open Issues |
| ---      |  ------------------------  |----------|---------------|----------------|------------------|------------------|-------|
| 1  | Convert GOCAD (TSurface) file into multiple triangulated meshes in VTU format, each mesh represents one layer boundary in 2D, i.e. the top surface plus the lower boundary of each stratigraphic unit | [GocadTSurfaceReader](https://www.opengeosys.org/docs/tools/fileio/gocadtsurfacereader/) | [GOCAD - TSurface](../master/input/models/2021-02-08_Strukturmodell_ts_irev02/Basisflaechen_Ton_Nord.ts) | Three out of 18 files shown here: [00_KB.vtu](./example-files/output/00_KB.vtu), [09_jo.vtu](./example-files/output/09_jo.vtu),[17_z.vtu](./example-files/output/17_z.vtu) | ![Screenshot Paraview - VTU with 3 selected layer boundaries and associated MaterialIDs](./figures/ExtractMaterials.png "Screenshot Paraview - VTU with 3 of 18 selected layer boundaries and associated MaterialIDs") | `GocadTSurfaceReader -i Basisflaechen_Ton_Nord.ts -o OGS_Ton_Nord` |[Read under Linux](https://gitlab.opengeosys.org/ogs/uc-dgr/dgr/-/issues/6)|
| (2) | Create ordered list of layers | manual / text editor | [Material parameter list - Excel](../master/input/parameters/ParameterlisteTonNord.xlsx)| [ordered layers txt](./example-files/input/Ton_Nord_Layers.txt)| |   |[Definition of format - csv](https://gitlab.opengeosys.org/ogs/uc-dgr/dgr/-/issues/7)|
| 3   | Create one vertical slice from layers |  [VerticalSliceFromLayers](https://www.opengeosys.org/docs/tools/getting-started/overview/) | 1. [ordered layers txt](./example-files/input/Ton_Nord_Layers.txt) ,2. [all files for layers vtu](./example-files/output)  | [Slices-VTU](./example-files/output/testslice.vtu) temporary (-t) [GEO](./example-files/output/testslice.geo), [MSH](./example-files/output/testslice.msh),  [GML](./example-files/output/testslice.gml), For this workflow the GEO-File is important.| ![Screenshot Gmesh - LineLoops](./figures/gmsh_lineloops.png  "Screenshot Gmesh - LineLoops")  | `VerticalSliceFromLayers -i Ton_Nord_Layers.txt -o testslice.vtu -t --start-x 9200 --start-y 9000 --end-x 18000 --end-y 20000 -r 100` | [Meshes with gaps](https://gitlab.opengeosys.org/ogs/uc-dgr/dgr/-/issues/10)|
| 4   | Create 2D mesh (msh gmsh) from polylines | [GMesh](https://gmsh.info/#Download)|[Gmsh GEO](./example-files/output/testslice.geo)|[Meshed Surface - msh](./example-files/output/testslice.msh) | ![Screenshot Gmesh - Meshed](./figures/gmsh_meshes.png "Screenshot Gmesh - Meshed") |`gmsh -2 testslice.geo` ||
| 5    | Convert mesh and extract domain mesh | [msh2vtu.py - Github](https://github.com/dominik-kern/msh2vtu) |[Meshed Surface - msh](./example-files/output/testslice.msh)| [Slice domain - VTU](./example-files/output/testslice_domain.vtu) | ![Screenshot Paraview - Domain mesh](./figures/domainmesh.png "Screenshot Paraview - Domain Mesh")|`msh2vtu.py -g testslice.vtu.msh`| |
| 6    | Extract boundary mesh |[ExtractBoundary](https://www.opengeosys.org/docs/tools/meshing-submeshes/extract-boundary/) | [Domain mesh](./example-files/output/testslice_domain.vtu)|[Physical Surface Boundary-VTU](./example-files/output/testslice_boundary.vtu) | ![Screenshot Paraview - Domain mesh](./figures/extractedboundary.png "Screenshot Paraview - Extracted boundary") |`ExtractBoundary -i testslice.vtu_domain.vtu -o testslice.vtu_boundary.vtu`||
| (7)    | Split boundary mesh (start/left, end/right, top, bottom) | [removeMeshElements](https://www.opengeosys.org/docs/tools/meshing/remove-mesh-elements/) | [Physical Surface Boundary-VTU](./example-files/output/testslice_boundary.vtu) | [bottom boundary - VTU](./example-files/output/testslice_bottom.vtu), [top boundary - VTU](./example-files/output/testslice_top.vtu), [startside](./example-files/output/testslice_left.vtu), [endside](./example-files/output/testslice_right.vtu) | ![Screenshot Paraview - Domain mesh](./figures/2of4boundaries.png "Screenshot Paraview - 2 Boundaries") <br>![Screenshot Paraview - Domain mesh](./figures/allboundaries.png "Screenshot Paraview - All boundaries")   | e.g. startside: <br>`removeMeshElements  -i testslice_physical_surfaces_boundary.vtu -o testslice_physical_surfaces_boundary_rme_startside.vtu --y-min 12776  --y-max 27000` | [concept](https://gitlab.opengeosys.org/ogs/uc-dgr/dgr/-/issues/9)|
| 8 | Modify OGS PRJ-File  | manual / text editor|[Material parameter list - Excel](./example-files/ParameterlisteTonNord.xlsx)|[PRJ-File](./example-files/input/simH_1.prj)||1. Add domain and boundary into meshes `<meshes>         <mesh>testslice_physical_surfaces_domain.vtu</mesh>` 2. Add materialparameter into media `<media><medium id="0">` |[generate prj](https://gitlab.opengeosys.org/ogs/uc-dgr/dgr/-/issues/7)|
| 9 | Run Simulation  | [OpenGeoSys](https://gitlab.opengeosys.org/ogs/ogs) |[PRJ-File](./example-files/input/simH_1.prj)|[pressure step 10 - VTU](./example-files/output/OGSoutput_sim_H_ts_1_t_1.000000.vtu) | ![Screenshot Paraview - Pressure at timestep 1](./figures/pressure_1.png "Screenshot Paraview - Pressure at timestep 1") |`ogs simH.prj` ||
| 10 | Postprocessing / Visualization  | [Paraview](https://www.paraview.org/) |[PVD-File](./example-files/output/OGSoutput_sim_H.pvd)|| ![Screenshot Paraview - Pressure at timestep 1](./figures/pressure_pvstate.png "Screenshot Paraview - Pressure at timestep 1") |`paraview OGSoutput_sim_H.pvd` ||

* Steps marked with "()"  will be simplified



 





## AutoCAD (deprecated)

The AutoCAD-based workflow is now replaced by the GOCAD (TSurface)-based workflow. With step 1-4 both result in a list of vtu-files. Each vtu file represents the lower boundary of a stratigraphic unit. 

| Step     | Description | Tool     | Example Input | Example Output |  Example Command | Example Image |
| ---      |  ---------  |----------|---------------|----------------|------------------|---------------|
| 1a   | Convert AutoCAD file into OGS msh with GINA   |  See manual below |||||
| 1b   | File exported by Gina will be converted into a VTU containing all layers   |  [OGS2VTK](https://www.opengeosys.org/docs/tools/getting-started/overview/)| [GINA OGS4 Msh](./example-files/GINA_output.msh) | [VTU with all layers and MaterialIDs](./example-files/vtk-layers.vtu) | `OGS2VTK -o vtk-layers.vtu -i example-files/GINA_output.msh` | ![Screenshot Paraview - VTU with all layer boundaries and associated MaterialIDs](./figures/vtuAllLayers.png "Screenshot Paraview - VTU with all layer boundaries and associated MaterialIDs") |
| 1c | Convert VTU file containing all layers into multiple VTUs, each VTU presents one layer (2D) and marks the lower boundary of rock layer (3D/volume)  | [ExtractMaterials](https://www.opengeosys.org/docs/tools/getting-started/overview/) | [VTU with all layers and MaterialIDs](./example-files/vtk-layers.vtu) | only first and last of 18 files shown here: [Layer0](./example-files/Ton_Nord_Layer0.vtu), [Layer17](./example-files/Ton_Nord_Layer17.vtu)| `ExtractMaterials -i vtk-layers.vtu -o Ton_Nord.vtu` |![Screenshot Paraview - VTU with 3 selected layer boundaries and associated MaterialIDs](./figures/ExtractMaterials.png "Screenshot Paraview - VTU with 3 of 18 selected layer boundaries and associated MaterialIDs")|
| 2 | Create list of ordered layers | manual / text editor | [Material parameter list - Excel](./example-files/ParameterlisteTonNord.xlsx)| [ordered layers txt](./example-files/Ton_Nord_Layers.txt)|    ||
| 3-   | Same steps as in GOCAD (TSurface)  | |||||


Export with GINA

- selectFile→Import...→AutoCAD DXF-File
- this  opens  the  DXF-Import  Dialog  of  GINA  where  preferences  regarding  the  particularflavour of AutoCAD DXF have to be set
- files by ERCOSPLAN require selecting “3D Face” and “MeshLab Export”
- select output name and path for the resulting msh-file
- check “Write Layername to File” and select a filename and path for the layername file  
- selectImport
- after the DXF data has been imported, exit GINA again viaFile→Exit
