# Getting started

The [Ton-Nord](../master/input/models/Ton-Nord/Basisflaechen_Ton-Nord.ts)  dataset is taken for alll examples presented below.

## First steps

### 1. Change into manual-workflow
`cd <dgr>/2D-workflow/manual-workflow`
### 2. Run with help option

`sh 2D_workflow.sh -h`\
Now all parameters are shown, the result is:

```
-----------------------------------------------------------------------------------------

2D_workflow.sh: runs deep geological repository workflow with 2D meshes (Vertical Slice).

Brief USAGE:
Syntax: sh 2D_workflow.sh [b|c|h|i|m|p|q|s]
  [-b "<BOUNDARIES>"]          mandatory
  [-i <MODEL_FILEPATHNAME>]    mandatory
  [-m <MODEL_NAME]             mandatory
  [-p <PROJECT_FILENAME>]      mandatory
  [-c <CONTAINER_SIF_FILE>]    optional, default: defined by env.sh
  [-q <QUAD_MESH>]             optional, default: inactive
  [-s <SLICE_ID>]              optional, default: 1

sh 2D_workflow.sh -h for further help

-----------------------------------------------------------------------------------------


<BOUNDARIES>
    double quoted array of 4 entries delimited by single space
    x_min y_min x_max y_max
    e.g. -b "9000 9200 18000 2000" 

<CONTAINER_SIF_FILE>
    absolute path to docker container file with 'sif' file ending
    e.g. -c ~/dgr/container/images/ogs-dgr_latest.sif

<MODEL_NAME>
    Ton_Nord
    e.g. -p Ton_Nord

<MODEL_FILENAME>
    full path name to GoCadTSurface file
    e.g. -i Basisflaechen_Ton_Nord.ts

<PROJECT_NAME>
    simH_1 or simH_2a or simH_2b or simHM_1
    A file with name equal to PROJECT_NAME and .prj extension in subfolder input
    e.g. -m simH_1

<SLICE_ID>
    any natural number
    e.g. -s 1

<QUAD_MESH>
    0 or 1
    e.g. -q 1
```

#### 3. Run the first example

`2D_workflow.sh -m Ton-Nord -p simH_1 -b "9200 9000 18000 20000" -i Basisflaechen_Ton-Nord.ts`\

The console output will be similar to [this](example_output.txt)

If successful a new folder is create with the following content:

```
00_KB.vtu
17_z.vtu
06_krh.vtu
15_so+m.vtu
07_krv.vtu
04_krp.vtu
13_S1.vtu
10_jm.vtu
03_S3.vtu
11_S2.vtu
02_krl.vtu
16_su+sm.vtu
09_jo.vtu
14_k.vtu
12_ju.vtu
08_wd.vtu
01_q.vtu
05_krb.vtu
testslice.gml
testslice.gml.md5
testslice.geo
testslice_left.vtu
testslice_top.vtu
testslice_right.vtu
testslice_bottom.vtu
testslice.vtu
testslice.msh
testslice_original.vtu
testslice_boundary.vtu
testslice_domain.vtu
simH_1.prj
OGSoutput_sim_H_ts_0_t_0.000000.vtu
OGSoutput_sim_H.pvd
OGSoutput_sim_H_ts_1_t_1.000000.vtu
ParaViewStateFile_simH_1.pvsm
```

#### 4. Visualize with Paraview

#### 4.1 Using the Paraview State File (PVSM)

In Paraview:  
1. File -> Load State
2. Navigate into the workflow output folder (see 3. run example)
3. Select .pvsm file
4. Choose "Search file under specified directory"
5. For Data Directoy navigate and choose workflow output folder (same as in step 2)

<img src="./ton-nord_simH_1.png"  width="75%">


#### 4.2 Using the (PVD)

In Paraview:
1. File -> Open
2. Navigate into the workflow output folder (see 3. run example)
3. Select .pvd file 

## How to continue

- Study [further examples](examples.md)
