# Examples

## Overview

| Dataset | H | M | HM | THM | THMC |
| ------ | ------ | ------ | ------ | ------ | ------ |
| Ton-Nord |- [simH_1: Gravity](#ton-nord_simh_1-hydraulic-simulation-under-gravity) <br> - [simH_2a: Inflow from the top](#ton-nord_simh_2a-hydraulic-simulation-with-inflow-from-the-top) <br> - [simH_2b: Transient flow behaviour](#ton-nord_simh_2b-hydraulic-simulation-with-inflow-from-the-top-transient-flow-behaviour) | - | - [simHM_1: Deformation under gravity](#ton-nord_simhm_1-hydraulic-mechanical-simulation) | - | X |
| Ton-Sued |- [simH_1: Gravity](#ton-sued_simh_1-hydraulic-simulation-under-gravity) <br> - [simH_2a: Inflow from the top](#ton-sued_simh_2a-hydraulic-simulation-with-inflow-from-the-top) <br> - [simH_2b: Transient flow behaviour](#ton-sued_simh_2b-hydraulic-simulation-with-inflow-from-the-top-transient-flow-behaviour) | - | - [simHM_1: Deformation under gravity](#ton-sued_simhm_1-hydraulic-mechanical-simulation) | - | X |
| Salz-flach |- [simH_1: Gravity](#salz-flach_simh_1-hydraulic-simulation-under-gravity)  <br> - [simH_2a: Inflow from the top](#salz-flach_simh_2a-hydraulic-simulation-with-inflow-from-the-top) <br> - [simH_2b: Transient flow behaviour](#salz-flach_simh_2b-hydraulic-simulation-with-inflow-from-the-top-transient-flow-behaviour) | - | - [simHM_1: Deformation under gravity](#salz-flach_simhm_1-hydraulic-mechanical-simulation) | - | - |
| Salz-Kissen |- [simH_1: Gravity](#salz-Kissen_simh_1-hydraulic-simulation-under-gravity)   <br> - [simH_2a: Inflow from the top](#salz-kissen_simh_2a-hydraulic-simulation-with-inflow-from-the-top) <br> - [simH_2b: Transient flow behaviour](#salz-kissen_simh_2b-hydraulic-simulation-with-inflow-from-the-top-transient-flow-behaviour)  | - | - [simHM_1: Deformation under gravity](#salz-kissen_simhm_1-hydraulic-mechanical-simulation) | - | - |
| Salz-Dom_Benchmark |- [Liquid-Flow](#salz-dom-benchmark_liquid_flow)  | - [Small-Deformation](#salz-dom-benchmark_small_deformation) | - | - | - |

## Prerequisites
Before running the example consider to check the [getting started](./getting_started.md).\
Change directory to working directory (folder that contains 2D_workflow.sh)

## Ton-Nord
### Ton-Nord_simH_1: Hydraulic simulation under gravity
`2D_workflow.sh -m Ton-Nord -p simH_1 -b "9200 9000 18000 20000" -i Basisflaechen_Ton-Nord.ts`\
The vertical slice domain shows a simple hydrostatic pressure distribution due to gravity.

<img src="./ton-nord_simH_1.png"  width="75%">

### Ton-Nord_simH_2a: Hydraulic simulation with inflow from the top
`sh 2D_workflow.sh -m Ton-Nord -p simH_2a -b "9200 9000 18000 20000" -i Basisflaechen_Ton-Nord.ts`\
The vertical slice domain shows a complex pressure and flow distribution caused by the inflow from the top (rain fall) and different hydraulic properties of the stratigraphic units.

<img src="../manual-workflow/figures/rainfall_transient_wo_gravitation.png"  width="75%">

### Ton-Nord_simH_2b: Hydraulic simulation with inflow from the top - transient flow behaviour
`sh 2D_workflow.sh -m Ton-Nord -p simH_2b -b "9200 9000 18000 20000" -i Basisflaechen_Ton-Nord.ts`\
The same simulation as 2a but resolving the transient flow behavior until the final state is reached.

<img src="./ton-nord_simH_2.png"  width="75%">

### Ton-Nord_simHM_1: Hydraulic-mechanical simulation 
`sh 2D_workflow.sh -m Ton-Nord -p simHM_1 -q 1 -b "9200 9000 18000 20000" -i Basisflaechen_Ton-Nord.ts`\
The vertical slice domain now has poro-elastic behavior such that the porous medium also deforms under gravity.\
The argument `-q 1` is for the creation of a quadratic mesh, necessary for HM simulations.

<img src="./ton-nord_simHM_1.png"  width="75%">

## Ton_Sued
### Ton-Sued_simH_1: Hydraulic simulation under gravity

### Ton-Sued_simH_2: Hydraulic simulation with inflow from the top
### Ton-Sued_simH_2b: Hydraulic simulation with inflow from the top - transient flow behaviour
### Ton-Sued_simHM_1: Hydraulic-mechanical simulation 


## Salz Dom Benchmark
### Salz-Dom-Benchmark_Liquid_Flow
`sh 2D_workflow.sh -m Salz-Dom-Benchmark -p saltz_dom_liqud_flow -o ` \

<img src="./salt_benchmark_liquid_flow.png"  width="75%"> \

### Salz-Dom-Benchmark_Small_Deformation

`sh 2D_workflow.sh -m Salz-Dom-Benchmark -p saltz_dom_M_initial_state -o`\
<img src="./salt_benchmark_initial_state.png"  width="75%"> \

## Salz-flach
### Salz-flach_simH_1: Hydraulic simulation under gravity
The l option is only because simH_1 has clay parameters (17) and this salt dataset 16. With l option the thin layer 6,12,16 are removed. \
`sh 2D_workflow.sh -m Salz-flach -p simH_1 -b "9000 1700 4450 10000" -i Basisflaechen_Salz-flach.ts -l`

<img src="./salz-flach_simH_1.png"  width="75%"> \
Other valid vertical slices: \
`sh 2D_workflow.sh -m Salz-flach -p simH_1 -b "3300 -1260 9000 1700" -i Basisflaechen_Salz-flach.ts -l` 
### Salz-flach_simH_2: Hydraulic simulation with inflow from the top
### Salz-flach_simH_2b: Hydraulic simulation with inflow from the top - transient flow behaviour
### Salz-flach_simHM_1: Hydraulic-mechanical simulation 


## Salz-Kissen
### Salz-Kissen_simH_1: Hydraulic simulation under gravity
`sh 2D_workflow.sh -m Salz-Kissen -p simH_1 -s 1 -b "1200 1550 13700 13000" -i Basisflaechen_Salz-Kissen.ts -l`\
`sh 2D_workflow.sh -m Salz-Kissen -p simH_1 -s 1 -b "1200 1550 13700 13000" -i Basisflaechen_Salz-Kissen.ts -l`
### Salz-Kissen_simH_2: Hydraulic simulation with inflow from the top
### Salz-Kissen_simH_2b: Hydraulic simulation with inflow from the top - transient flow behaviour
### Salz-Kissen_simHM_1: Hydraulic-mechanical simulation 
