
# Define a set

Edit dgr/input/parameters/toys.csv

- Below is an example of a toy (set_id=0).
- It takes the layer-bounds (0,1,5,13) from model_id (1-Ton-Nord). The top-most layer is treated special it is not defining the lower bound of a layer (as all the others bounds). 
- The example defines 3 layers. 
- Resolution: The first layer (row: 0,1,1,5,1) is devided into 5 equally spaced sublayers. The lower bound is layer_id=1, the upper bound is layer_id=0 (defined by previous row)
- The first layers takes the parameter values from model_id=1 and layer_id 1 (defined by material_id)

An example set (set_id) is defined in the csv file below:

```
set_id,model_id,layer_id,resolution,material_id
0,1,0,0,0
0,1,1,5,1
0,1,5,15,4
0,1,13,5,12
```

Extend the table with an incremented set_ip (here 1)

ModelIDs:
1- Ton-Nord
2- Ton-Sued
3- Salz-Kissen / Salz-flach (same Materialparameterset)

# Modify call of 2D-workflow

- specify the toy (set_id) with parameter `-y`
- specify the toy resolution in y-axis with parameter `-z`

## example Salz-Kissen
```sh 2D_workflow.sh -m Salz-Kissen -p simT_1 -b "9200 9000 18000 20000" -i Basisflaechen_Salz-Kissen.ts  -s 3D_toy_Salz-Kissen_3 -d 3 -y 3 -z 50```

## example Ton-Nord

```sh 2D_workflow.sh -m Ton-Nord -p simH_1 -b "9200 9000 18000 20000" -i Basisflaechen_Ton-Nord.ts  -s 3D_toy_Ton-Nord -d 3 -y 1 -z 25```
