# make sure path ogs6py is known via pip or e.g. (your path!)
# export PYTHONPATH=$PYTHONPATH:~/git4ifgt/ogs6py
import ogs
# This script generates an OGS input-file (prj) for a variable number of materials 
# (<medium> sections). It depends on ogs6py and requires the number of materials
# and their parameters set in its preamble. 

# It processes the two files
# - OGStemplate_main.prj    with empty media block, i.e. only whitespaces between <media> tags.
# - OGStemplate_medium.xml  with the medium parameters, to be set inside <medium> 
#
# The output is written to (existing files get overwritten)
# - OGSmain.prj		containing include-directives to
# - OGSmedium_0.xml
# - OGSmedium_1.xml
# - ...


# material data (medium) from table
N_mat=4	# make sure greater than zero	
viscosity_list = [1e-3, 1e-3, 1e-3, 1e-3]
density_list = [1e3, 1e3, 1e3, 1e3]
permeability_list = [1e-7, 1e-8, 1e-7, 1e-12]
porosity_list = [0.6, 0.2, 0.6, 0.1]
storage_list = [0.0, 0.0, 0.0, 0.0]
names_list = [ "rockA" , "rockB", "Cstone", "Dstone", "Esand" ]


###   PROCESS MEDIA (soil layers)   ###

# enter parameters into template (ogs6py)
medium_template_filename = "OGStemplate_medium.xml"
medium_filenames=[]	
for n in range(N_mat):
    medium_filename="OGSmedium_"+str(n)+"_"+names_list[n]+".xml"
    medium_filenames.append(medium_filename)
    medium_xml= ogs.OGS(INPUT_FILE=medium_template_filename, PROJECT_FILE=medium_filename)

    medium_xml.replaceTxt(viscosity_list[n], xpath="./phases/phase/properties/property[name='viscosity']/value")
    medium_xml.replaceTxt(density_list[n], xpath="./phases/phase/properties/property[name='density']/value")
    medium_xml.replaceTxt(permeability_list[n], xpath="./properties/property[name='permeability']/value")
    medium_xml.replaceTxt(porosity_list[n], xpath="./properties/property[name='porosity']/value")
    medium_xml.replaceTxt(storage_list[n], xpath="./properties/property[name='storage']/type") 
    
    medium_xml.writeInput()


# The <medium> tags were needed for ogs6py but are removed now,
# they will be reinserted as numbered <medium id ...>  in main.prj.
# This approach was chosen, as OGS allows only one file inclusion per XML-tag
for n in range(N_mat):
    medium_filedata = open(medium_filenames[n]).read()
    medium_filedata = medium_filedata.replace('<medium>', '')
    medium_filedata = medium_filedata.replace('</medium>','')
    medium_file = open(medium_filenames[n], 'w')
    medium_file.write(medium_filedata)
    medium_file.close



###   PROCESS MAIN FILE   ###

# add medium blocks (ogs6py)
main_template_filename='OGStemplate_main.prj'
main_filename="OGSmain.prj"
main_prj= ogs.OGS(INPUT_FILE=main_template_filename, PROJECT_FILE=main_filename)

for n in range(N_mat):
    include_file="<include file="+medium_filenames[n]+"/>"    
    main_prj.addEntry(parent_xpath="./media", tag="medium", text=include_file, attrib="id", attrib_value=str(n))

main_prj.writeInput()  


# ogs6py codes "<" as "&lt;" and ">" as  "&gt;", although XML readers should accept this, we replace it for sake of beauty
main_filedata = open(main_filename).read()
main_filedata = main_filedata.replace('&lt;', '<')
main_filedata = main_filedata.replace('&gt;','>')
main_file = open(main_filename, 'w')
main_file.write(main_filedata)
main_file.close



# this is how to replace other parameters than media (ogs6py)
#medium_prj.= ogs.OGS(INPUT_FILE=in, PROJECT_FILE=out)
#medium_prj.replaceTxt(9.81, xpath="./processes/process/darcy_gravity/g")
