#This is for asses the indicator species

library(indicspecies)

rm(list = ls())

#load data

crust <- read.table("data/trans_crust.txt", header = T, sep = "\t")
crust2 <- crust[, -c(1:6)]


#indicator species ----

#this is for the indicator species of groups (3 habitats * 2 time = 6 groups)
ind.sp <- multipatt(crust2, paste(crust$habitat, crust$time2, sep = ""), func = "IndVal.g",
                    duleg = T, control = how(nperm=999))

summary(ind.sp, indvalcomp = T)

saveRDS(ind.sp, "data/ind_sp.rds")

#This is done