#This is for analyze if the habitats (rice, marsh and limnocrene), 
#seasons (4 sampling) and natural park influence 
#on the entire community

library(vegan)
library(RVAideMemoire)

rm(list = ls())

#load data

crust <- read.table("data/trans_crust.txt", header = T, sep = "\t")
crust2 <- crust[,-c(1:6)]

#Test if the groups have similar dispersion ----

#create a distance matrix
crust.d <- vegdist(crust2, method = "bray")

#Permdist to evaluate if the groups have similar dispersion
#Spatial: Albufera - Pego
disp.area <- betadisper(crust.d, group=crust$area)
permutest(disp.area) # p<0.05 == differences in variance

#Temporal: w1 - w2 - s1 - s2
disp.seasonal <- betadisper(crust.d, group = crust$time)
permutest(disp.seasonal)

#Habitat: rice - marsh - limnocrene
disp.habitat <- betadisper(crust.d, group=crust$habitat)
permutest(disp.habitat)

#Compare 2 by 2 the groups to see if they present similar variances
TukeyHSD(disp.habitat)

plot(disp.area)
plot(disp.habitat)
plot(disp.seasonal)

#PERMANOVA to test if the communities vary among groups ----
ad.inter <- adonis2(crust.d ~ crust$time + crust$habitat + crust$area, 
                    permutations = 999, method="bray")
ad.inter


#pairwise comparisons for adonis2
pairwise.perm.manova(crust.d, crust$time)
pairwise.perm.manova(crust.d, crust$habitat)

# This is done