#This is for applying hellinguer transformation to species data set

library(vegan)

rm(list = ls())

#load data

crust <- read.table("data/raw_crust.txt", header = T, sep = "\t")
crust2 <- crust[,-c(1:6)]


#apply hellinger transformation

crust.t <- decostand(crust2, method = "hellinger")


#save the transformed df

crust.t <- cbind(crust[,1:6], crust.t)

write.table(crust.t, file = "data/trans_crust.txt", sep = "\t",
            row.names = F, col.names = T)

#This is done