#This is for alpha diversity

library(ggplot2)
library(plyr)

rm(list = ls())

#load data

crust <- read.table("data/raw_crust.txt", header = T, sep = "\t")
crust2 <- crust[,-c(1:6)]

crust$habitat <- revalue(crust$habitat, c("marsh" = "1marsh",
                                          "rice" = "2rice",
                                          "limnocrene" = "3limno"))

#Change number of individuals by presence/absence of the species

crust3 <- crust2
crust3[crust3 > 0] <- 1

#number of species

crust4 <- rowSums(crust3)

#mean of the 4 seasons for each of the 32 points sampled

mean4 <- aggregate(crust4 ~ crust$site, data=crust, mean)


#mean of the sampled points for each habitat group

habitat <- crust[1:32 , 3]

mean.hab <- aggregate(crust4 ~ habitat, data=mean4, mean)
sd.hab <- aggregate(crust4 ~ habitat, data=mean4, sd)

#boxplot for the three habitats
pdf(file = "results/alpha.pdf", width = 10, height = 9)

ggplot(data = mean4, aes(x =habitat, y = crust4)) +
  geom_boxplot(fill = c("#009e73", "#d55e00", "#0072b2"), width=0.4) +
  geom_jitter(size=2, width = 0.2) +
  ylim(0,20)

dev.off()

#GLM for testing differences in habitats and sampling campaigns
crust5 <- rowSums(crust3)
hist(crust5)

model <- glm(crust5 ~ crust$habitat*crust$time, family = poisson)

summary(model)

#This is done