#This is for gamma diversity

library(vegan)
library(ggplot2)
library(iNEXT)

rm(list = ls())

#load data

crust <- read.table("data/raw_crust.txt", header = T, sep = "\t")
crust2 <- crust[,-c(1:6)]


#sample-size based rarefaction and extrapolation curves
#Habitat: prepare rice, marsh and limnocrene data for iNEXT

rice <- subset(crust2, crust$habitat == "rice")
rice2 <- rice
rice2[rice2 > 0] <- 1
rice2 <- t(rice2)
irice <- as.data.frame(as.incfreq(rice2))

marsh <- subset(crust2, crust$habitat == "marsh")
marsh2 <- marsh
marsh2[marsh2 > 0] <- 1
marsh2 <- t(marsh2)
imarsh <- as.data.frame(as.incfreq(marsh2))

limnocrene <- subset(crust2, crust$habitat == "limnocrene")
limnocrene2 <- limnocrene
limnocrene2[limnocrene2 > 0] <- 1
limnocrene2 <- t(limnocrene2)
ilimnocrene <- as.data.frame(as.incfreq(limnocrene2))

ihab <- cbind(irice, imarsh, ilimnocrene)
colnames(ihab) <- c("rice", "marsh", "limnocrene")

#obtain and plot interp. and extrap.of Hill numbers (0)
hab0 <- iNEXT(ihab, datatype = "incidence_freq")
  
p <-ggiNEXT(hab0, type = 1) +
  scale_shape_manual(values=c(15, 16, 17)) +
  scale_colour_manual(values=c("#0072b2", "#009e73", "#d55e00"))+
  scale_fill_manual(values=c("#0072b2", "#009e73", "#d55e00")) +
  ylab("Number of species") +
  xlab("Number of samples")

print(p)

ggsave(p, file = "results/diversity_crust.pdf", width = 8, height = 6)

#This is done