#include "Loom_EZORGB.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////
Loom_EZORGB::Loom_EZORGB(Manager& man, byte address, bool useMux) : EZOSensor("EZO-RGB"), manInst(&man){
    module_address = address;

    if(!useMux)
        manInst->registerModule(this);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZORGB::initialize(){
    Wire.begin();
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZORGB::measure(){
    if(moduleInitialized){

        // Attempt to read data from the sensor
        if(!readSensor(400)){
            ERROR(F("Failed to read sensor!"));
            return;
        }

        // Parse the constructed string
        parseData(getSensorData());
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZORGB::package(){
    if(moduleInitialized){
        JsonObject json = manInst->get_data_object(getModuleName());
        json["Red"] = rgb[0];
        json["Green"] = rgb[1];
        json["Blue"] = rgb[2];
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZORGB::power_down() {
    if(moduleInitialized){
        if(!sendTransmission("sleep")){
            ERROR(F("Failed to send 'sleep' command to device"));
        }
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZORGB::parseData(const char* sensorData){
    // Parse out the comma separated strings
    char* splitPointer;
    char response[33];
    strncpy(response, sensorData, 33);
    
    splitPointer = strtok(response, ",");
    rgb[0] = atoi(splitPointer);

    splitPointer = strtok(NULL, ",");
    rgb[1] = atoi(splitPointer);

    splitPointer = strtok(NULL, ",");
    rgb[2] = atoi(splitPointer);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////