#include "Loom_EZOPH.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////
Loom_EZOPH::Loom_EZOPH(Manager& man, byte address, bool useMux) : EZOSensor("EZO-PH"), manInst(&man){
    module_address = address;

    if(!useMux)
        manInst->registerModule(this);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZOPH::initialize(){
    Wire.begin();
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZOPH::measure(){
    if(moduleInitialized){

        // Attempt to read data from the sensor
        if(!readSensor(1000)){
            ERROR(F("Failed to read sensor!"));
            return;
        }

        // Parse the constructed string
        ph = atof(getSensorData());  
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZOPH::package(){
    if(moduleInitialized){
        JsonObject json = manInst->get_data_object(getModuleName());
        json["PH"] = ph;
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZOPH::power_down() {
    if(moduleInitialized){
        if(!sendTransmission("sleep")){
            ERROR(F("Failed to send 'sleep' command to device"));
        }
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////