#include "Loom_EZODO.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////
Loom_EZODO::Loom_EZODO(Manager& man, byte address, bool useMux) : EZOSensor("EZO-DO"), manInst(&man){
    module_address = address;

    if(!useMux)
        manInst->registerModule(this);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZODO::initialize(){
    Wire.begin();
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZODO::measure(){
    if(moduleInitialized){

        // Attempt to read data from the sensor
        if(!readSensor(700)){
            ERROR(F("Failed to read sensor!"));
            return;
        }

        // Parse the constructed string
        parseResponse(getSensorData());
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZODO::package(){
    if(moduleInitialized){
        JsonObject json = manInst->get_data_object(getModuleName());
        json["D-Ox"] = oxygen;
        json["Sat"] = saturation;
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZODO::power_down() {
    if(moduleInitialized){
        if(!sendTransmission("sleep")){
            ERROR(F("Failed to send 'sleep' command to device"));
        }
    }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
void Loom_EZODO::parseResponse(const char* response){
    char* splitResponse; 
    char internalResponse[33];
    strncpy(internalResponse, response, 33);

    // Split response at , and store the first half in oxygen
    splitResponse = strtok(internalResponse, ",");
    oxygen = atof(splitResponse);

    // And the second half in saturation
    splitResponse = strtok(NULL, ",");
    saturation = atof(splitResponse);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////