#include "Loom_BatchSD.h"
#include "Logger.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////
Loom_BatchSD::Loom_BatchSD(Loom_Hypnos& hypnos, int batchSize) : batchSize(batchSize){
    sdMan = hypnos.getSDManager();
    sdMan->setBatchSize(batchSize);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
bool Loom_BatchSD::shouldPublish(){
    return (sdMan->getCurrentBatch() == batchSize);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
File& Loom_BatchSD::getBatch(){
    return sdMan->getFile(sdMan->getBatchFilename());
}
//////////////////////////////////////////////////////////////////////////////////////////////////////