# Data from: The basic-reproduction number of infectious diseases in spatially structured host populations

[https://doi.org/10.5061/dryad.kh18932fw](https://doi.org/10.5061/dryad.kh18932fw)

Computer code to support the above-named article.

## Description of the data and file structure

Files provided include two .c files and one .h file which can be compiled to create an executable to simulate epidemics using a stochastic individual based model. The .cfg file (as well as command line flags) can be altered to affect the parameterisation of this simulation. There are also three .R files; running one creates a host landscape for the epidemic simulation; the other two can be used to calculate R0 using the methods set out in our paper, and to calculate the same quantity numerically by fitting a (multi-species) branching process model (i.e., a way of checking that the analytic method gives reliable results).

## Sharing/Access information

The code is also available at 

*   [https://github.com/nikcunniffe/rZeroORing](https://github.com/nikcunniffe/rZeroORing)

Note that compiling the EpidemicSim.c file requires a C implementation of the Mersenne Twister. In doing the runs underneath the paper, a modified version of mt19937ar was used. This was originally written by Takuji Nishimura and Makoto Matsumoto, and cannot be released under a CC0 licence. However, a copy of the files used - with an appropriate copyright declaration - is hosted at [https://doi.org/10.5281/zenodo.11244650](https://doi.org/10.5281/zenodo.11244650) 

## Code/Software

The pipeline for creating landscape(s), running epidemics and calculating R0 is described below.

1.  Compile EpidemicSim.exe from EpidemicSim.c and mt19937ar.c
2.  Create directory to do the runs
3.  Copy the following files to directory created in step 2
    *   EpidemicSim.cfg
    *   EpidemicSim.exe
    *   create_LS.R
    *   rZero_From_Sims.R
    *   rZero_Function.R
4.  Create the following subdirectories of directory created in step 2
    *   Inputs
    *   Outputs
5.  Start R and change to the directory created in step 2 using setwd()
6.  Run create_LS.R
    *   Options for landscape generation are in the R file
    *   Running it will fill up Inputs subdirectory
7.  Run EpidemicSim.exe on command line
    *   Options for epidemics are in the EpidemicSim.cfg files
    *   will fill up Outputs subdirectory
8.  Run rZero_From_Sims.R
    *   will print estimated and calculated rZero to the screen



