# Contributing to Pybehave

The following guidelines are designed for contributors to pybehave.

## Reporting Issues, Asking Questions, and Requesting Features

For reporting a bug, asking a question, or requesting a new feature, open an issue in GitHub's [issue tracker](https://github.com/tne-lab/py-behav-box-v2/issues). 
First, search through existing issues (open or closed) that might have the answer to your question.

When reporting a bug, it is most helpful to include:

- A quick background/summary
- Specific steps to reproduce, with sample code if you can
- The expected result
- The actual result
- Notes (i.e. why you think this might be happening, or things you tried that didn't work)

## Contributing Code or Documentation

To make contributions to pybehave, request your changes or contributions via a pull request against the `dev` branch of the
pybehave repository if making changes to code or the `docs` branch if making changes to documentation alone.

Please use the following steps:

1. Fork the pybehave repository to your GitHub account
2. Clone your fork locally with `git clone`
3. Create a new branch with a name that describes your contribution. 
4. Make your changes on this new branch.
5. Push your changes to your fork.
6. [Submit a pull request](https://github.com/tne-lab/py-behav-box-v2/pulls) against the `dev` or `docs` branch in pybehave depending on the contribution.

## License

By contributing, you agree that your contributions will be licensed under its MIT License.