import pandas as pd
import numpy as np
import math, json, os
from libs.test import test_random_goals

with open('param.json', 'r') as file:
    pr = json.load(file)


def test_score(root_path, data_dirs):

    pd.options.display.float_format = '{:.4f}'.format
    tab = np.zeros([len(pr["globals"]["seeds"]), len(data_dirs)])

    for i, exp_name in enumerate(data_dirs):

        data_dir = root_path + pr["paths"]["test_random_goals"] + '/' + exp_name         

        for j in range(len(pr["globals"]["seeds"])):

            f = os.path.join(data_dir, 'run_' + str(j), 'progress.txt')
            if not os.path.exists(f):
                test_random_goals(root_path, 100, exp_name, j)

            try:
                dt = pd.read_table(data_dir + '/run_' + str(j) + '/progress.txt')
            except:
                print('Could not read from %s' % f)
                continue
            
            TestEpRet = dt['TestEpRet'].to_numpy()
            for r in range(len(TestEpRet)):
                TestEpRet[r] = - math.log(1 - TestEpRet[r])
            tab[j][i] = TestEpRet.mean()

    df = pd.DataFrame(tab, columns=data_dirs, index=['run_' + str(j) for j in range(len(pr["globals"]["seeds"]))])

    tab_mean = tab.mean(axis=0)
    df_m = pd.DataFrame(np.array([tab_mean]), columns=data_dirs, index=['mean'])

    tab_std = tab.std(axis=0)
    df_s = pd.DataFrame(np.array([tab_std]), columns=data_dirs, index=['std'])

    print("=======================================================")
    print('Test Scores:')
    # print(df)
    print("-------------------------------------------------------")
    print(df_m)
    print("-------------------------------------------------------")
    print(df_s)
    print("=======================================================")


def training_score(root_path, data_dirs):

    pd.options.display.float_format = '{:.4f}'.format
    tab = np.zeros([len(pr["globals"]["seeds"]), len(data_dirs)])

    for i, folder in enumerate(data_dirs):
        for j in range(len(pr["globals"]["seeds"])):

            dt = pd.read_table(root_path + pr["paths"]["training"] + '/' + folder + '/run_' + str(j) + '/progress.txt')
            TestEpRet = dt['AverageEpRet'].to_numpy()
            tab[j][i] = - math.log(1 - TestEpRet[-1])

    df = pd.DataFrame(tab, columns=data_dirs, index=['run_' + str(j) for j in range(len(pr["globals"]["seeds"]))])

    tab_mean = tab.mean(axis=0)
    df_m = pd.DataFrame(np.array([tab_mean]), columns=data_dirs, index=['mean'])

    tab_std = tab.std(axis=0)
    df_s = pd.DataFrame(np.array([tab_std]), columns=data_dirs, index=['std'])

    print("=======================================================")
    print('Training Scores:')
    # print(df)
    print("-------------------------------------------------------")
    print(df_m)
    print("-------------------------------------------------------")
    print(df_s)
    print("=======================================================")


def collision_rates(root_path, data_dirs):

    pd.options.display.float_format = '{:.4f}'.format
    cls_rate = np.zeros([len(pr["globals"]["seeds"]), len(data_dirs)])

    for i, exp_name in enumerate(data_dirs):

        data_dir = root_path + pr["paths"]["test_random_goals"] + '/' + exp_name

        for j in range(len(pr["globals"]["seeds"])):

            f = os.path.join(data_dir, 'run_' + str(j), 'progress.txt')
            if not os.path.exists(f):
                test_random_goals(root_path, 100, exp_name, j)

            try:
                dt = pd.read_table(data_dir + '/run_' + str(j) + '/progress.txt')
            except:
                print('Could not read from %s' % f)
                continue

            CollisionFlags = dt['CollisionFlag'].to_numpy()
            cls_rate[j][i] = len(CollisionFlags[CollisionFlags > 0])/len(CollisionFlags)

    df_collision = pd.DataFrame(cls_rate, columns=data_dirs, index=['run_' + str(j) for j in range(len(pr["globals"]["seeds"]))])
    df_cls_mean = pd.DataFrame(np.array([cls_rate.mean(axis=0)]), columns=data_dirs, index=['mean'])
    df_cls_std = pd.DataFrame(np.array([cls_rate.std(axis=0)]), columns=data_dirs, index=['std'])

    print("=======================================================")
    print('Collision Rates:')
    # print(df_collision)
    print("-------------------------------------------------------")
    print(df_cls_mean)
    print(df_cls_std)