import os, json, sys

root_path = os.getcwd()
sys.path.append(root_path + '/simulators')
sys.path.append(root_path + '/algorithms')

with open('param.json', 'r') as file:
    p = json.load(file)


def main(case):

    if case == 0:
        from algorithms.ibc_dmp import train
    elif case == 1:
        from algorithms.ebc_dmp import train
    elif case == 2:
        from algorithms.demo_dmp import train
    else:
        from algorithms.ddpg_dmp import train

    train(root_path)
    

if __name__ == '__main__':

    ## Select mode:
    #   0:          IBC-DMP
    #   1:          EBC-DMP
    #   2:          DEMO-DMP
    #   3 or else:  DDPG-DMP (Conventional DDPG)

    main(case=3)
