## Implicit Behavior Cloning and Dynamic Movement Primitive Facilitated Reinforcement Learning (IBC-DMP RL) for Robot Motion Planning

**Author:** Zengjie Zhang (z.zhang3@tue.nl)

This project demonstrates a novel reinforcement learning approach for the motion planning of robot manipulators facilitated by Implicit Behavior Cloning (IBC) and Dynamic Movement Primitive (DMP).

## Introduction

#### Associated Research Work

- This library is associated with the Arxiv article in [https://arxiv.org/abs/2307.16062](https://arxiv.org/abs/2307.16062).

#### Relation with Existing Toolbox

- The algorithms in this project are modified from the [spinningup](https://github.com/openai/spinningup) toolbox. 

## Installation

**Operating system**
 - *Windows* (compatible in general, succeed on 11)
 - *Linux* (compatible in general, succeed on 20.04)
 
**GPU**
- *CUDA* 11.2

**Python Environment**
 - Python version: test passed on `python=3.9`
 - **Recommended**: IDE ([VS code](https://code.visualstudio.com/) or [Pycharm](https://www.jetbrains.com/pycharm/)) and [Conda](https://www.anaconda.com/)
 - Python Dependencies: the dependent packages are listed in `requirement.txt`. For `Conda`, use the following commands to install the dependencies:
  ```
  conda install -c anaconda numpy
  conda install -c conda-forge matplotlib
  conda install -c anaconda scipy
  conda install -c anaconda joblib
  conda install -c conda-forge pybullet
  conda install -c anaconda pandas
  conda install -c intel mpi4py
  conda install -c anaconda seaborn
  conda install -c conda-forge gymnasium
  conda install -c conda-forge setuptools
  ```
- Pytorch with CUDA: install `pytorch` according to the instructions here: [https://pytorch.org/get-started/locally/](https://pytorch.org/get-started/locally/)

## Quick Run

#### Human Demonstration Dataset Preparation
- Backup all existing data;
- Download the dataset `human_motion.zip` from [https://zenodo.org/record/11237258](https://zenodo.org/record/11237258);
- Unzip `human_motion.zip` and place the folder `dataset_motion` parallel with this repository; Make sure the architecture goes like `IBC-DMP/ -> human_motion/ -> dataset/`.

#### Train the agents

- Open `train.py` in the root directory;
- Modify the case code to specify the training algorithm:
  ```
  main(case=3)  
  ```
  `0` for `IBC-DMP`, `1` for `EBC-DMP`, `2` for `DEMO-DMP`, `3 or else` for  `DDPG-DMP (Conventional DDPG)`
- Run `train.py` to train the selected agent.

#### Visualize the results

- Open `visualize.py` in the root directory;
- Specify the experiment name `exp_name` among `'IBC-DMP'`, `'DEMO-DMP'`, `'DDPG-DMP'`, and `'EBC-DMP'`;
- Select the desired function and comment others out:
  - Draw the learning curves in training:
  ```
  from visualization.learning_curves import learning_curves
  learning_curves(root_path, exp_name)
  ```
  - Draw the tested trajectories with fixed goals:
  ```
  from visualization.draw_in_3d import draw_fixed_goal
  draw_fixed_goal(root_path, exp_name)
  ```
- Run `visualize.py` to generate the visualization.


#### Print the scores

- Open `score.py` in the root directory;
- Select the desired function and comment others out:
  - Print the training scores:
  ```
  from visualization.print_scores training_score
  training_score(root_path, exp_name)
  ```
  - Print the test scores:
  ```
  from visualization.print_scores test_score
  test_score(root_path, exp_name)
  ```
  - Print the collision rates:
  ```
  from visualization.print_scores collision_rates
  collision_rates(root_path, exp_name)
  ```
- Run `score.py` to print the training or test scores.

