! ***********************************************************************
!
!   Copyright (C) 2012  Bill Paxton
!
!   this file is part of mesa.
!
!   mesa is free software; you can redistribute it and/or modify
!   it under the terms of the gnu general library public license as published
!   by the free software foundation; either version 2 of the license, or
!   (at your option) any later version.
!
!   mesa is distributed in the hope that it will be useful, 
!   but without any warranty; without even the implied warranty of
!   merchantability or fitness for a particular purpose.  see the
!   gnu library general public license for more details.
!
!   you should have received a copy of the gnu library general public license
!   along with this software; if not, write to the free software
!   foundation, inc., 59 temple place, suite 330, boston, ma 02111-1307 usa
!
! *********************************************************************** 
      module run_binary_extras 

      use star_lib
      use star_def
      use const_def
      use const_def
      use chem_def
      use num_lib
      use binary_def
      use crlibm_lib
      
      implicit none
      
      contains
      
      subroutine extras_binary_controls(binary_id, ierr)
         integer :: binary_id
         integer, intent(out) :: ierr
         type (binary_info), pointer :: b
         ierr = 0

         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in binary_ptr'
            return
         end if

         ! Set these function pointers to point to the functions you wish to use in
         ! your run_binary_extras. Any which are not set, default to a null_ version
         ! which does nothing.
         b% how_many_extra_binary_history_header_items => how_many_extra_binary_history_header_items
         b% data_for_extra_binary_history_header_items => data_for_extra_binary_history_header_items
         b% how_many_extra_binary_history_columns => how_many_extra_binary_history_columns
         b% data_for_extra_binary_history_columns => data_for_extra_binary_history_columns

         b% other_extra_jdot=> cew_jdot
         b% extras_binary_startup=> extras_binary_startup
         b% extras_binary_start_step=> extras_binary_start_step
         b% extras_binary_check_model=> extras_binary_check_model
         b% extras_binary_finish_step => extras_binary_finish_step
         b% extras_binary_after_evolve=> extras_binary_after_evolve

         ! Once you have set the function pointers you want, then uncomment this (or set it in your star_job inlist)
         ! to disable the printed warning message,
          b% warn_binary_extra =.false.
         
      end subroutine extras_binary_controls


      integer function how_many_extra_binary_history_header_items(binary_id)
         use binary_def, only: binary_info
         integer, intent(in) :: binary_id
         how_many_extra_binary_history_header_items = 0
      end function how_many_extra_binary_history_header_items

      subroutine data_for_extra_binary_history_header_items( &
           binary_id, n, names, vals, ierr)
         type (binary_info), pointer :: b
         integer, intent(in) :: binary_id, n
         character (len=maxlen_binary_history_column_name) :: names(n)
         real(dp) :: vals(n)
         integer, intent(out) :: ierr
         ierr = 0
         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in binary_ptr'
            return
         end if
      end subroutine data_for_extra_binary_history_header_items


      integer function how_many_extra_binary_history_columns(binary_id)
         use binary_def, only: binary_info
         integer, intent(in) :: binary_id
         how_many_extra_binary_history_columns = 0 
      end function how_many_extra_binary_history_columns
      
      subroutine data_for_extra_binary_history_columns(binary_id, n, names, vals, ierr)
         use const_def, only: dp
         type (binary_info), pointer :: b
		 type (star_info), pointer :: s
         integer, intent(in) :: binary_id
         integer, intent(in) :: n
         character (len=maxlen_binary_history_column_name) :: names(n)
         real(dp) :: vals(n)
         real(dp) :: G,alpha,mlt,vc,omega,Ledd
         real(dp) :: cspeed,eta,jdot,L_2,L_f,L_tot,L_nuc
         real(dp) :: rho,M_2,m_wd,mdot_cr,mdot_wd
         real(dp) :: Tce,Mtot,Rce,Tsun,X,Reimers
         real(dp) :: wind1,wind2,M_ce,mdot_wind,mdot_ce
		 real(dp) :: mtransfer_cr, xfer_m1,mdot_he,eta_he,eta_hyd
         integer, intent(out) :: ierr
         real(dp) :: beta
         ierr = 0
         call binary_ptr(binary_id, b, ierr)
         call star_ptr(binary_id, s, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in binary_ptr'
            return
         end if

      end subroutine data_for_extra_binary_history_columns
      
      
      integer function extras_binary_startup(binary_id,restart,ierr)
         type (binary_info), pointer :: b
         integer, intent(in) :: binary_id
         integer, intent(out) :: ierr
         logical, intent(in) :: restart
         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then ! failure in  binary_ptr
            return
         end if
         
!          b% s1% job% warn_run_star_extras = .false.
          extras_binary_startup = keep_going
      end function  extras_binary_startup
      
      integer function extras_binary_start_step(binary_id,ierr)
         type (binary_info), pointer :: b
         integer, intent(in) :: binary_id
         integer, intent(out) :: ierr

         extras_binary_start_step = keep_going
         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then ! failure in  binary_ptr
            return
         end if
      
      end function  extras_binary_start_step
      
      !Return either rety,backup,keep_going or terminate
      integer function extras_binary_check_model(binary_id)
         type (binary_info), pointer :: b
         integer, intent(in) :: binary_id
         integer :: ierr
         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then ! failure in  binary_ptr
            return
         end if  
         extras_binary_check_model = keep_going
        
      end function extras_binary_check_model

      subroutine cew_jdot(binary_id, ierr)
         integer, intent(in) :: binary_id
         integer, intent(out) :: ierr
         real(dp) :: G,M_ce,alpha,mlt,vc,omega,Ledd
         real(dp) :: cspeed,eta,jdot,L_2,L_f,L_tot,L_nuc
         real(dp) :: rho,M_2,m_wd,mdot_ce,mdot_cr,mdot_wd
         real(dp) :: Tce,mdot_wind,Mtot,Rce,Tsun,X,Reimers
         real(dp) :: wind1,wind2
		 real(dp) :: mtransfer_cr, xfer_m1,mdot_he,eta_he,eta_hyd
         type (binary_info), pointer :: b
         type (star_info), pointer :: s
         ierr = 0
         call binary_ptr(binary_id, b, ierr)
         call star_ptr(binary_id, s, ierr)

         ! NOTE: surface is outermost cell. not necessarily at photosphere.
         ! NOTE: don't assume that vars are set at this point.
         ! so if you want values other than those given as args,
         ! you should use values from s% xh(:,:) and s% xa(:,:) only.
         ! rather than things like s% Teff or s% lnT(:) which have not been set yet.


         if (ierr /= 0) then
            write(*,*) 'failed in binary_ptr'
            return
         end if

         s => b% s_donor

!!!!!!!!!!!!!!!!!!!!!!!!Define a critical mass transfer rate,compare this rate with mdot,then get eta_h,
!!!!!!!!!!!!!!!!!!!!!!!!1-beta = eta_h.


         mtransfer_cr = 5.3d0*10d0**(-7d0)*(1.7d0-b% s_donor% surface_h1)*(b% m(b% a_i)/Msun-0.4d0)/(b% s_donor% surface_h1)
         b% mtransfer_rate = secyer * b% mtransfer_rate  

         write(*,*) b% s_donor% surface_h1
         if (abs(b% mtransfer_rate/Msun) >=  mtransfer_cr) then  
             eta_hyd = mtransfer_cr / abs(b% mtransfer_rate/Msun)
         else if(mtransfer_cr > abs(b% mtransfer_rate/Msun) .and. ( 0.125d0 * mtransfer_cr < abs(b% mtransfer_rate/Msun)))then
                     eta_hyd = 1d0
         else
                     eta_hyd = 0d0
         end if     
         mdot_he = eta_hyd * abs(b% mtransfer_rate/Msun)

         write(*,*) 'Yeshha'
		 write(*,*) mtransfer_cr
         write(*,*) b% mtransfer_rate/Msun
		 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!Meng2009
         if (abs(b% mtransfer_rate/Msun) > mtransfer_cr)then 
             eta_he = 1d0
         else
            if (1.40d0 <= b% m(b% a_i)/Msun) then
                if (mdot_he <10**(-6.05d0)) then
                    eta_he = -0.115d0*(safe_log10_cr(mdot_he)+5.7d0)**2 +1.01d0
                else 
                    eta_he = 1d0
                end if
            else if ((1.3d0 <= b% m(b% a_i)/Msun).and.(b%m(b%a_i)/Msun < 1.35d0)) then
                if (mdot_he <10**(-5.83d0)) then
                    eta_he = -0.175d0*(safe_log10_cr(mdot_he)+5.35d0)**2+1.03d0
                else 
                    eta_he = 1d0
                end if
      
            else if ((1.1d0 <= b% m(b% a_i)/Msun) .and.(b% m(b% a_i)/Msun < 1.3d0)) then
                if (mdot_he < 10**(-5.95d0)) then
                    eta_he = 0.54d0*safe_log10_cr(mdot_he)+4.16
                else if ((10**(-5.95d0) <= mdot_he).and.(mdot_he <10**(-5.76d0))) then
                        eta_he = -0.54d0*(safe_log10_cr(mdot_he)+5.6d0)**2+1.01d0
                else 
                    eta_he = 1d0
                end if
            else if ((1.0d0 <= b% m(b% a_i)/Msun).and.(b% m(b% a_i)/Msun < 1.1d0)) then
                if (mdot_he < 10**(-6.05d0) ) then
                    eta_he = -0.35d0*(safe_log10_cr(mdot_he)+5.6d0)**2+1.01d0
                else 
                    eta_he = 1.0d0
                end if
            else if ((0.9d0 <= b% m(b% a_i)/Msun).and.(b% m(b% a_i)/Msun < 1.0d0)) then
                if (mdot_he < 10**(-6.05d0)) then
                    eta_he = -0.35d0*(safe_log10_cr(mdot_he)+5.6d0)**2+1.07d0
                else 
                    eta_he = 1.0d0
                end if
            else if ((0.8d0 <= b% m(b% a_i)/Msun).and.(b% m(b% a_i)/Msun < 0.9d0)) then
                if (mdot_he < 10d0** (-6.34d0)) then
                   eta_he = -0.35d0*(safe_log10_cr(mdot_he) + 6.1d0)**2 + 1.02d0
                else 
                   eta_he = 1d0
                end if
            else 
                eta_he = 1
            end if 
         end if 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!11
  		 b% mtransfer_rate =b% mtransfer_rate/(secyer)

         M_ce = b% s1% x_ctrl(11) !g M_ce has an unit of g
         eta = b% s1% x_ctrl(2)

         G = b% s_donor% cgrav(1) !cgs
         alpha = 10 
         mlt = 0.1*b% separation 
         vc = 0.26*sqrt(G*Msun/b% separation)
         omega = 2*pi/b% period
         M_wd = b% m(b% a_i)/Msun
         M_2 = b% m(b% d_i)/Msun
         Ledd = 3.3d4*(M_wd+M_2+M_ce/Msun) !L_\odot

         !CE radius
         Tce = 3000
         Tsun = 5777
         Rce = ((Tce/Tsun)/((M_wd+M_2+M_ce/Msun)**0.1))**(-10)*Rsun!cm
         write(*,*)'Rce',M_wd+M_2+M_ce/Msun,Rce/Rsun

         !mdot_wind = 1d-13*(Reimers)

         cspeed = 29979245800 !cm/s
         X = b% s_donor% surface_h1
         L_2 = b% s_donor% L_surf
         Mtot = M_2+M_wd+M_ce/Msun
         mdot_cr = 5.3d-7*(1.7-X)/X*(M_wd-0.4) !M_\odot yr^-1
         L_f = alpha*eta*G*(Mtot*Msun)/Lsun
         L_nuc = 0.007*X*mdot_cr*Msun/secyer*cspeed**2/Lsun
         L_tot = L_nuc + L_2 + L_f


         !mdot_wd !!!
         b% fixed_xfer_fraction = eta_hyd * eta_he 
         b% mass_transfer_beta = 1-eta_hyd*eta_he
         mdot_wd = abs((1-b% mass_transfer_beta) * b% mtransfer_rate)
         !mdot_wind first is set to be 0!
         mdot_wind = 0

         write(*,*)'Ledd',Ledd,L_tot
         !mdot_ce = 0
         if (abs(b% mtransfer_rate)/Msun*secyer > mdot_cr) then 
             mdot_wd = mdot_cr*Msun/secyer
             !eta_hyd = 1
             !eta_he = mdot_cr / abs(b% mtransfer_rate/Msun*secyer)
             eta_he = 1
             mdot_ce = abs(b% mtransfer_rate) - mdot_wd - mdot_wind
             write(*,*)'YES!!!',mdot_ce/Msun*secyer,mdot_wd/Msun*secyer,mdot_wind/Msun*secyer
             write(*,*)'YES!!!',abs(b% mtransfer_rate)/Msun*secyer-mdot_wd/Msun*secyer
         elseif (M_ce > 0) then
             mdot_wd = mdot_cr*Msun/secyer
             eta_hyd = 1
             eta_he = mdot_cr / abs(b% mtransfer_rate/Msun*secyer)
             mdot_ce = abs(b% mtransfer_rate) - mdot_wd - mdot_wind
         else 
             mdot_ce = 0
         endif

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         b% fixed_xfer_fraction = eta_hyd * eta_he 
         b% mass_transfer_beta = 1-eta_hyd*eta_he
		 write(*,*)'GAGAGAGA', mdot_he,eta_hyd,eta_he,b% fixed_xfer_fraction
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


         !if (abs(b% mtransfer_rate)/Msun*secyer < mdot_cr .and. M_ce > 0.00001)then
         !    write(*,*)'NONONONON'
         !    mdot_ce = -1*mdot_wind
         !endif


         if (s% model_number .eq. s% init_model_number+1) then 
             s% x_ctrl(7) = s% init_model_number
         endif
         s% x_ctrl(7) = 1 + s% x_ctrl(7)

         write(*,*)'XXXXXX',s% init_model_number

         if (int(s% x_ctrl(7)) .eq. s% model_number)then 
         b% s1% x_ctrl(11) = mdot_ce &
                *b% s_donor% time_step*secyer + b% s1% x_ctrl(11) !g
         else 
             write(*,*)'RETRY !!!!!!!!!'
         endif
         !b% s1% x_ctrl(1) = M_ce
         M_ce = b% s1% x_ctrl(11)

         if (M_ce<0) M_ce = 0

         write(*,*)'Model_num',s% model_number,s% x_ctrl(7)
         write(*,*)'M_ce_comm',M_ce/Msun
         write(*,*)'HAHAHHA',safe_log10_cr(s% time_step),M_ce/Msun,M_2,M_ce/Msun+M_2
         write(*,*)'TESTX',mdot_ce/Msun*secyer,b% mtransfer_rate/Msun*secyer
         write(*,*)'MENG1',mdot_ce/Msun*secyer,mdot_wind/Msun*secyer,mdot_cr
         write(*,*)'MENG2',L_tot,Ledd,L_nuc,L_2,L_f
         write(*,*)'MENG3',b% mtransfer_rate/Msun*secyer,mdot_cr
         write(*,*)'Timestep',b% s_donor% time_step

         rho = M_ce/((4/3.)*pi*Rce**3.0)
         eta = rho*mlt*vc/2
         b% s1% x_ctrl(2) = eta
!         if (M_ce > 0) then 
!            jdot = -1*alpha*eta*pow3(b% separation)*omega
!            !b% extra_jdot = 0 
!            b% extra_jdot = jdot 
!         else 
!            b% extra_jdot = 0 
!         end if
         if (M_ce > 0) then 
            !!!!!!!!!!!
            if (L_tot<=Ledd) then
                jdot = -1*alpha*eta*pow3(b% separation)*omega
                !b% extra_jdot = 0 
                b% extra_jdot = jdot 
            else
                L_f = Ledd-L_nuc-L_2
                jdot = -1*L_f*Lsun*pow3(b% separation)*omega/(G*(Mtot*Msun))
                b% extra_jdot = jdot 
            endif
         else 
            b% extra_jdot = 0 
         end if
         write(*,*)'MENGX',M_ce/Msun,s% x_ctrl(2),b% extra_jdot

         !Now consider the CE wind!
         if (L_tot<=Ledd)then  
            Reimers = (L_tot*Rce/Rsun)/(Mtot)*Msun/secyer
            mdot_wind = 1d-13*Reimers !M_\odot yr^-1
         else 
            mdot_wind = (Ledd*Rce/Rsun)/(Mtot)*Msun/secyer*1d-13
         endif

         write(*,*)'!!!!!!!!!!!!!!!!!!!!!Mdot_wind_new',mdot_wind/Msun*secyer,L_tot,Ledd,Rce/Rsun

         if (int(s% x_ctrl(7)) .eq. s% model_number)then 
            b% s1% x_ctrl(11) = -1*mdot_wind &
                   *b% s_donor% time_step*secyer + b% s1% x_ctrl(11) !g
         endif
         !!endif !1 time for 1 model

         if (s% x_ctrl(7)>s% model_number)then
             s% x_ctrl(7) = s% x_ctrl(7) - 1
         endif

         M_ce = b% s1% x_ctrl(11)

         write(*,*)'M_ce_af1',M_ce/Msun,mdot_wind
         if (M_ce<0) M_ce = 0
         write(*,*)'M_ce_af2',M_ce/Msun

         b% s1% x_ctrl(11) = M_ce




      end subroutine cew_jdot

      
      
      ! returns either keep_going or terminate.
      ! note: cannot request retry or backup; extras_check_model can do that.
      integer function extras_binary_finish_step(binary_id)
         type (binary_info), pointer :: b
         type (star_info), pointer :: s
         integer, intent(in) :: binary_id
         integer :: ierr
         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then ! failure in  binary_ptr
            return
         end if  
         extras_binary_finish_step = keep_going

         s => b% s_donor
         if (abs(b% mtransfer_rate/Msun*secyer) > 1e-3) then 
             extras_binary_finish_step = terminate
         write(*,*)'Terminate due to unstable MT!'
         endif
         if (abs(b% mtransfer_rate/Msun*secyer) < 1e-8 .and. b% m(b% d_i)/Msun < 1.2) then 
             extras_binary_finish_step = terminate
         write(*,*)'Terminate due to finish accretion!'
         endif
         if (b% m(b% a_i)/Msun > 1.40) then 
             extras_binary_finish_step = terminate
         write(*,*)'Terminate due to SN Ia!'
         endif



         
      end function extras_binary_finish_step
      
      subroutine extras_binary_after_evolve(binary_id, ierr)
         type (binary_info), pointer :: b
         integer, intent(in) :: binary_id
         integer, intent(out) :: ierr
         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then ! failure in  binary_ptr
            return
         end if      
         
 
      end subroutine extras_binary_after_evolve     
      
      end module run_binary_extras
