"""Shared parameters for dipole_clusters.

Version 1.2.1,  May 1, 2024, tested with Python 3.11.7, rated 10.00/10

"""
import sys
import numpy as np
try:
    from dipole_clusters_modules import dipole_cluster as dct
    from dipole_clusters_modules.plot_tools import Gt
except ImportError:
    sys.path.append(r'D:\Py\general')
    import dipole_cluster as dct
    from plot_tools import Gt


class Mg:
    """Shared variables."""

    cluster_dic = {'Tetra':  dct.Tetrahedron(),
                   'Cube':   dct.Cube(tau_deg=None, edge=(2, 2, 2)),
                   'Octa':   dct.Octahedron(),
                   # 'Dodeca': dct.Dodecahedron(), # now from Tetraplex(cut=2)
                   # 'Icosa':  dct.Icosahedron(), # now from Tetraplex(cut=1)
                   # 'Rings':  dct.Rings(l_r=(24, 30, 36),
                   #                    rad=(49.6, 63.6, 77.6)),
                   'Rings':  dct.Rings(l_r=(30, 36),
                                       rad=(63.6, 77.6)),
                   'Tubes':  dct.Tube(tri=False, n_rz=(16, 1), dst=0.0, mom=1),
                   'Hexagon': dct.HexagonFilled(1),
                   'HCP':    dct.HCP(),
                   'FCC':    dct.FCC(),
                   'RCO':    dct.Rco(),
                   'C60':    dct.C60(),
                   'TPlex':  dct.Tetraplex(without=0, cut=0)}

    disp = {'axes':    True,  # set your initial values here
            'direc':   False,
            'arrows':  True,
            'contact': True,
            'diam':    True,
            'sphrs':   False,
            'plane':   False,
            'sphere':  False,
            'refresh': True,
            'msg':     Gt.comment}
    clu_act, clu_num = None, None
    g = dct.GeoPlane(route=np.array([0.2, 0.3, 1.]),
                     d_p=3, width=2, st_sz=0.01,
                     origin=np.array([0.0, 0.0, 0.0]), length=1000.)

    @staticmethod
    def select_start_cluster(cluster='Tetra'):
        """Set the cluster instance and its RadioButton number."""
        if Mg.clu_act is not None:
            del Mg.clu_act  # might not be neccessary, does no harm either
        Mg.clu_act = Mg.cluster_dic.get(cluster)
        Mg.clu_num = list(Mg.cluster_dic.keys()).index(cluster)  # valinit

    @staticmethod
    def liste():
        """Just a dummy."""
        print(dir.Mg)
