/******************************************************************************
 *   Copyright (C) 2019 GSI Helmholtzzentrum für Schwerionenforschung GmbH    *
 *   Copyright (C) 2019-2024 Members of R3B Collaboration                     *
 *                                                                            *
 *             This software is distributed under the terms of the            *
 *                 GNU General Public Licence (GPL) version 3,                *
 *                    copied verbatim in the file "LICENSE".                  *
 *                                                                            *
 * In applying this license GSI does not waive the privileges and immunities  *
 * granted to it by virtue of its status as an Intergovernmental Organization *
 * or submit itself to any jurisdiction.                                      *
 ******************************************************************************/

/********************************************************
 *
 * Structure for ext_data_fetch_event() filling.
 *
 * Do not edit - automatically generated.
 */

#ifndef __GUARD_H101_EXT_H101_FI4_H__
#define __GUARD_H101_EXT_H101_FI4_H__

#ifndef __CINT__
#include <stdint.h>
#else
/* For CINT (old version trouble with stdint.h): */
#ifndef uint32_t
typedef unsigned int uint32_t;
typedef int int32_t;
#endif
#endif
#ifndef EXT_STRUCT_CTRL
#define EXT_STRUCT_CTRL(x)
#endif

/********************************************************
 *
 * Plain structure (layout as ntuple/root file):
 */

typedef struct EXT_STR_h101_FI4_t
{
    uint32_t fiberfour1tM /* [1,16] */;
    uint32_t fiberfour1tMI[16 EXT_STRUCT_CTRL(fiberfour1tM)] /* [1,16] */;
    uint32_t fiberfour1tME[16 EXT_STRUCT_CTRL(fiberfour1tM)] /* [1,160] */;
    uint32_t fiberfour1t /* [0,160] */;
    uint32_t fiberfour1tv[160 EXT_STRUCT_CTRL(fiberfour1t)] /* [0,65535] */;
    uint32_t fiberfour1EM /* [1,16] */;
    uint32_t fiberfour1EMI[16 EXT_STRUCT_CTRL(fiberfour1EM)] /* [1,16] */;
    uint32_t fiberfour1EME[16 EXT_STRUCT_CTRL(fiberfour1EM)] /* [1,160] */;
    uint32_t fiberfour1E /* [0,160] */;
    uint32_t fiberfour1Ev[160 EXT_STRUCT_CTRL(fiberfour1E)] /* [-1,-1] */;
    uint32_t fiberfour2tM /* [1,16] */;
    uint32_t fiberfour2tMI[16 EXT_STRUCT_CTRL(fiberfour2tM)] /* [1,16] */;
    uint32_t fiberfour2tME[16 EXT_STRUCT_CTRL(fiberfour2tM)] /* [1,160] */;
    uint32_t fiberfour2t /* [0,160] */;
    uint32_t fiberfour2tv[160 EXT_STRUCT_CTRL(fiberfour2t)] /* [0,65535] */;
    uint32_t fiberfour2EM /* [1,16] */;
    uint32_t fiberfour2EMI[16 EXT_STRUCT_CTRL(fiberfour2EM)] /* [1,16] */;
    uint32_t fiberfour2EME[16 EXT_STRUCT_CTRL(fiberfour2EM)] /* [1,160] */;
    uint32_t fiberfour2E /* [0,160] */;
    uint32_t fiberfour2Ev[160 EXT_STRUCT_CTRL(fiberfour2E)] /* [-1,-1] */;
    uint32_t fiberfour3tM /* [1,16] */;
    uint32_t fiberfour3tMI[16 EXT_STRUCT_CTRL(fiberfour3tM)] /* [1,16] */;
    uint32_t fiberfour3tME[16 EXT_STRUCT_CTRL(fiberfour3tM)] /* [1,160] */;
    uint32_t fiberfour3t /* [0,160] */;
    uint32_t fiberfour3tv[160 EXT_STRUCT_CTRL(fiberfour3t)] /* [0,65535] */;
    uint32_t fiberfour3EM /* [1,16] */;
    uint32_t fiberfour3EMI[16 EXT_STRUCT_CTRL(fiberfour3EM)] /* [1,16] */;
    uint32_t fiberfour3EME[16 EXT_STRUCT_CTRL(fiberfour3EM)] /* [1,160] */;
    uint32_t fiberfour3E /* [0,160] */;
    uint32_t fiberfour3Ev[160 EXT_STRUCT_CTRL(fiberfour3E)] /* [-1,-1] */;
    uint32_t fiberfour4tM /* [1,16] */;
    uint32_t fiberfour4tMI[16 EXT_STRUCT_CTRL(fiberfour4tM)] /* [1,16] */;
    uint32_t fiberfour4tME[16 EXT_STRUCT_CTRL(fiberfour4tM)] /* [1,160] */;
    uint32_t fiberfour4t /* [0,160] */;
    uint32_t fiberfour4tv[160 EXT_STRUCT_CTRL(fiberfour4t)] /* [0,65535] */;
    uint32_t fiberfour4EM /* [1,16] */;
    uint32_t fiberfour4EMI[16 EXT_STRUCT_CTRL(fiberfour4EM)] /* [1,16] */;
    uint32_t fiberfour4EME[16 EXT_STRUCT_CTRL(fiberfour4EM)] /* [1,160] */;
    uint32_t fiberfour4E /* [0,160] */;
    uint32_t fiberfour4Ev[160 EXT_STRUCT_CTRL(fiberfour4E)] /* [-1,-1] */;
    uint32_t fiberfour5tM /* [1,16] */;
    uint32_t fiberfour5tMI[16 EXT_STRUCT_CTRL(fiberfour5tM)] /* [1,16] */;
    uint32_t fiberfour5tME[16 EXT_STRUCT_CTRL(fiberfour5tM)] /* [1,160] */;
    uint32_t fiberfour5t /* [0,160] */;
    uint32_t fiberfour5tv[160 EXT_STRUCT_CTRL(fiberfour5t)] /* [0,65535] */;
    uint32_t fiberfour5EM /* [1,16] */;
    uint32_t fiberfour5EMI[16 EXT_STRUCT_CTRL(fiberfour5EM)] /* [1,16] */;
    uint32_t fiberfour5EME[16 EXT_STRUCT_CTRL(fiberfour5EM)] /* [1,160] */;
    uint32_t fiberfour5E /* [0,160] */;
    uint32_t fiberfour5Ev[160 EXT_STRUCT_CTRL(fiberfour5E)] /* [-1,-1] */;
    uint32_t fiberfour6tM /* [1,16] */;
    uint32_t fiberfour6tMI[16 EXT_STRUCT_CTRL(fiberfour6tM)] /* [1,16] */;
    uint32_t fiberfour6tME[16 EXT_STRUCT_CTRL(fiberfour6tM)] /* [1,160] */;
    uint32_t fiberfour6t /* [0,160] */;
    uint32_t fiberfour6tv[160 EXT_STRUCT_CTRL(fiberfour6t)] /* [0,65535] */;
    uint32_t fiberfour6EM /* [1,16] */;
    uint32_t fiberfour6EMI[16 EXT_STRUCT_CTRL(fiberfour6EM)] /* [1,16] */;
    uint32_t fiberfour6EME[16 EXT_STRUCT_CTRL(fiberfour6EM)] /* [1,160] */;
    uint32_t fiberfour6E /* [0,160] */;
    uint32_t fiberfour6Ev[160 EXT_STRUCT_CTRL(fiberfour6E)] /* [-1,-1] */;
    uint32_t fiberfour7tM /* [1,16] */;
    uint32_t fiberfour7tMI[16 EXT_STRUCT_CTRL(fiberfour7tM)] /* [1,16] */;
    uint32_t fiberfour7tME[16 EXT_STRUCT_CTRL(fiberfour7tM)] /* [1,160] */;
    uint32_t fiberfour7t /* [0,160] */;
    uint32_t fiberfour7tv[160 EXT_STRUCT_CTRL(fiberfour7t)] /* [0,65535] */;
    uint32_t fiberfour7EM /* [1,16] */;
    uint32_t fiberfour7EMI[16 EXT_STRUCT_CTRL(fiberfour7EM)] /* [1,16] */;
    uint32_t fiberfour7EME[16 EXT_STRUCT_CTRL(fiberfour7EM)] /* [1,160] */;
    uint32_t fiberfour7E /* [0,160] */;
    uint32_t fiberfour7Ev[160 EXT_STRUCT_CTRL(fiberfour7E)] /* [-1,-1] */;
    uint32_t fiberfour8tM /* [1,16] */;
    uint32_t fiberfour8tMI[16 EXT_STRUCT_CTRL(fiberfour8tM)] /* [1,16] */;
    uint32_t fiberfour8tME[16 EXT_STRUCT_CTRL(fiberfour8tM)] /* [1,160] */;
    uint32_t fiberfour8t /* [0,160] */;
    uint32_t fiberfour8tv[160 EXT_STRUCT_CTRL(fiberfour8t)] /* [0,65535] */;
    uint32_t fiberfour8EM /* [1,16] */;
    uint32_t fiberfour8EMI[16 EXT_STRUCT_CTRL(fiberfour8EM)] /* [1,16] */;
    uint32_t fiberfour8EME[16 EXT_STRUCT_CTRL(fiberfour8EM)] /* [1,160] */;
    uint32_t fiberfour8E /* [0,160] */;
    uint32_t fiberfour8Ev[160 EXT_STRUCT_CTRL(fiberfour8E)] /* [-1,-1] */;
    uint32_t fiberfour9tM /* [1,16] */;
    uint32_t fiberfour9tMI[16 EXT_STRUCT_CTRL(fiberfour9tM)] /* [1,16] */;
    uint32_t fiberfour9tME[16 EXT_STRUCT_CTRL(fiberfour9tM)] /* [1,160] */;
    uint32_t fiberfour9t /* [0,160] */;
    uint32_t fiberfour9tv[160 EXT_STRUCT_CTRL(fiberfour9t)] /* [0,65535] */;
    uint32_t fiberfour9EM /* [1,16] */;
    uint32_t fiberfour9EMI[16 EXT_STRUCT_CTRL(fiberfour9EM)] /* [1,16] */;
    uint32_t fiberfour9EME[16 EXT_STRUCT_CTRL(fiberfour9EM)] /* [1,160] */;
    uint32_t fiberfour9E /* [0,160] */;
    uint32_t fiberfour9Ev[160 EXT_STRUCT_CTRL(fiberfour9E)] /* [-1,-1] */;

} EXT_STR_h101_FI4;

/********************************************************
 *
 * Structure with multiple levels of arrays (partially)
 * recovered (recommended):
 */

typedef struct EXT_STR_h101_FI4_onion_t
{
    /* RAW */
    struct
    {
        uint32_t tM;
        uint32_t tMI[16 /* tM */];
        uint32_t tME[16 /* tM */];
        uint32_t t;
        uint32_t tv[160 /* t */];
        uint32_t EM;
        uint32_t EMI[16 /* EM */];
        uint32_t EME[16 /* EM */];
        uint32_t E;
        uint32_t Ev[160 /* E */];
    } fiberfour[9];

} EXT_STR_h101_FI4_onion;

/*******************************************************/

#define EXT_STR_h101_FI4_ITEMS_INFO(ok, si, offset, struct_t, printerr)                                      \
    do                                                                                                       \
    {                                                                                                        \
        ok = 1;                                                                                              \
        /* RAW */                                                                                            \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour1tM, UINT32, "fiberfour1tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour1tMI, UINT32, "fiberfour1tMI", "fiberfour1tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour1tME, UINT32, "fiberfour1tME", "fiberfour1tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour1t, UINT32, "fiberfour1t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour1tv, UINT32, "fiberfour1tv", "fiberfour1t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour1EM, UINT32, "fiberfour1EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour1EMI, UINT32, "fiberfour1EMI", "fiberfour1EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour1EME, UINT32, "fiberfour1EME", "fiberfour1EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour1E, UINT32, "fiberfour1E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour1Ev, UINT32, "fiberfour1Ev", "fiberfour1E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour2tM, UINT32, "fiberfour2tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour2tMI, UINT32, "fiberfour2tMI", "fiberfour2tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour2tME, UINT32, "fiberfour2tME", "fiberfour2tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour2t, UINT32, "fiberfour2t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour2tv, UINT32, "fiberfour2tv", "fiberfour2t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour2EM, UINT32, "fiberfour2EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour2EMI, UINT32, "fiberfour2EMI", "fiberfour2EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour2EME, UINT32, "fiberfour2EME", "fiberfour2EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour2E, UINT32, "fiberfour2E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour2Ev, UINT32, "fiberfour2Ev", "fiberfour2E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour3tM, UINT32, "fiberfour3tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour3tMI, UINT32, "fiberfour3tMI", "fiberfour3tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour3tME, UINT32, "fiberfour3tME", "fiberfour3tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour3t, UINT32, "fiberfour3t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour3tv, UINT32, "fiberfour3tv", "fiberfour3t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour3EM, UINT32, "fiberfour3EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour3EMI, UINT32, "fiberfour3EMI", "fiberfour3EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour3EME, UINT32, "fiberfour3EME", "fiberfour3EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour3E, UINT32, "fiberfour3E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour3Ev, UINT32, "fiberfour3Ev", "fiberfour3E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour4tM, UINT32, "fiberfour4tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour4tMI, UINT32, "fiberfour4tMI", "fiberfour4tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour4tME, UINT32, "fiberfour4tME", "fiberfour4tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour4t, UINT32, "fiberfour4t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour4tv, UINT32, "fiberfour4tv", "fiberfour4t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour4EM, UINT32, "fiberfour4EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour4EMI, UINT32, "fiberfour4EMI", "fiberfour4EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour4EME, UINT32, "fiberfour4EME", "fiberfour4EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour4E, UINT32, "fiberfour4E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour4Ev, UINT32, "fiberfour4Ev", "fiberfour4E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour5tM, UINT32, "fiberfour5tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour5tMI, UINT32, "fiberfour5tMI", "fiberfour5tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour5tME, UINT32, "fiberfour5tME", "fiberfour5tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour5t, UINT32, "fiberfour5t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour5tv, UINT32, "fiberfour5tv", "fiberfour5t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour5EM, UINT32, "fiberfour5EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour5EMI, UINT32, "fiberfour5EMI", "fiberfour5EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour5EME, UINT32, "fiberfour5EME", "fiberfour5EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour5E, UINT32, "fiberfour5E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour5Ev, UINT32, "fiberfour5Ev", "fiberfour5E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour6tM, UINT32, "fiberfour6tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour6tMI, UINT32, "fiberfour6tMI", "fiberfour6tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour6tME, UINT32, "fiberfour6tME", "fiberfour6tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour6t, UINT32, "fiberfour6t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour6tv, UINT32, "fiberfour6tv", "fiberfour6t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour6EM, UINT32, "fiberfour6EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour6EMI, UINT32, "fiberfour6EMI", "fiberfour6EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour6EME, UINT32, "fiberfour6EME", "fiberfour6EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour6E, UINT32, "fiberfour6E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour6Ev, UINT32, "fiberfour6Ev", "fiberfour6E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour7tM, UINT32, "fiberfour7tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour7tMI, UINT32, "fiberfour7tMI", "fiberfour7tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour7tME, UINT32, "fiberfour7tME", "fiberfour7tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour7t, UINT32, "fiberfour7t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour7tv, UINT32, "fiberfour7tv", "fiberfour7t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour7EM, UINT32, "fiberfour7EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour7EMI, UINT32, "fiberfour7EMI", "fiberfour7EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour7EME, UINT32, "fiberfour7EME", "fiberfour7EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour7E, UINT32, "fiberfour7E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour7Ev, UINT32, "fiberfour7Ev", "fiberfour7E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour8tM, UINT32, "fiberfour8tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour8tMI, UINT32, "fiberfour8tMI", "fiberfour8tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour8tME, UINT32, "fiberfour8tME", "fiberfour8tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour8t, UINT32, "fiberfour8t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour8tv, UINT32, "fiberfour8tv", "fiberfour8t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour8EM, UINT32, "fiberfour8EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour8EMI, UINT32, "fiberfour8EMI", "fiberfour8EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour8EME, UINT32, "fiberfour8EME", "fiberfour8EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour8E, UINT32, "fiberfour8E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour8Ev, UINT32, "fiberfour8Ev", "fiberfour8E");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour9tM, UINT32, "fiberfour9tM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour9tMI, UINT32, "fiberfour9tMI", "fiberfour9tM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour9tME, UINT32, "fiberfour9tME", "fiberfour9tM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour9t, UINT32, "fiberfour9t", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour9tv, UINT32, "fiberfour9tv", "fiberfour9t");        \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour9EM, UINT32, "fiberfour9EM", 16); \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour9EMI, UINT32, "fiberfour9EMI", "fiberfour9EM");     \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour9EME, UINT32, "fiberfour9EME", "fiberfour9EM");     \
        EXT_STR_ITEM_INFO_LIM(ok, si, offset, struct_t, printerr, fiberfour9E, UINT32, "fiberfour9E", 160);  \
        EXT_STR_ITEM_INFO_ZZP(                                                                               \
            ok, si, offset, struct_t, printerr, fiberfour9Ev, UINT32, "fiberfour9Ev", "fiberfour9E");        \
                                                                                                             \
    } while (0);

#endif /*__GUARD_H101_EXT_H101_FI4_H__*/

/*******************************************************/
