# Overview of the Califa classes

TClonesArray data (typically FairMultiLinkedData)
Event data on various levels.
Generally in ../r3bdata/califaData/.
Event data classes will be written [[like this]] in this file.

### (Main) FairTasks:
Classes generating new, higher level TClonesArray data from
existing data.
Tasks will be written in double curly braces here.

Tasks are:

- ./sim/R3BCalifaDigitizer.h
- ./calibration/R3BCalifaMapped2CrystalCal.h
- ./calibration/R3BCalifaCrystalCal2Cluster.h
- ./calibration/R3BCalifaCrystalCal2CrystalCalPID.h

### Parameter containers

These files generally hold channel-specific data used for calibration and the like.

- ./pars/R3BCalifaMappingPar.h
- ./pars/R3BCalifaCrystalCalPar.h
- ./pars/R3BCalifaTotCalPar.h
- ./pars/R3BCalifaClusterPar.h
- ./pars/R3BCalifaGeometry.h -- helper class to fetch infos on the positions and orientation of the crystals
- ./pars/R3BCalifaContFact.h

To make sure that these are impossible to create/edit/view by unauthorized programs such as
text editors or shell scripts, these classes are generally serialized to ROOT's exclusive binary
only .root format. (There exist apostate rumors of a legacy FairParAsciiFileIo format which is
readable by both humans and 3rd party tools.)

### online FairTasks
- ./online/R3BCalifaOnlineSpectra.h
- ./online/R3BCalifaDemoOnlineSpectra.h

### calibration: optional FairTasks
- ./calibration/R3BCalifaMapped2CrystalCalPar.h -- generate a new energy calibration file from a source run.
- ./calibration/R3BCalifaCrystalCal2TotCalPar.h.h -- generate a tot energy calibration file from a source run.

### ana: optional FairTasks

- ./ana/R3BCalifaCrystalCalDataAnalysis.h

### other

- ./ROOT_template_hacks.h -- helper class to wrap ROOT stuff in a std c++ way
- ./CalifaLinkDef.h       -- linking directives for CINT. 
- ../geometry/califa*.root -- 14 different ROOT-only binary files containing the material and orientation
of the crystals and holding structure. At one point, these were probably generated by any of the 9 files matching
- ../macros/r3b/geo/create_califa*.C. The pigeonhole principle suggests that there is not a bijection between
the latter and the former. 

#  Califa processing chains

### Simulation branch

- ./sim/R3BCalifa.h
 generates a data structure called
 [[../r3bdata/califaData/R3BCalifaPoint.h]],
 which is then used by 
- ./sim/R3BCalifaDigitizer.h
 to generate the simulation version of
[[../r3bdata/califaData/R3BCalifaCrystalCalData.h]].

### Unpack / experiment data branch

../r3bsource/R3BCalifaFebexReader.h is involved in parsing the lmd (with help from ucesb) to generate
[[../r3bdata/califaData/R3BCalifaMappedData.h]].
This is then read by {{./calibration/R3BCalifaMapped2CrystalCal.h}}
to generate [[../r3bdata/califaData/R3BCalifaCrystalCalData.h]] by applying per-channel, per-experiment parameters (./pars/R3BCalifaCrystalCalPar.h and ./pars/R3BCalifaTotCalPar.h if Tot data are available). 

### Processing to hit level aka clustering

[[../r3bdata/califaData/R3BCalifaCrystalCalData.h]] data from either source (sim/exp) is converted by
{{./R3BCalifaCrystalCal2Cluster.h}}
to
[[../r3bdata/califaData/R3BCalifaClusterData.h]]



