C
C________________________________________________________________
C
C     FUNCTION  F _ S e _ P G 6 0 
C________________________________________________________________
C
C FUNCTION F_Se_PG60 IS THE EXTERNAL SURFACE SCATTERING
C COEFFICIENT (Se) FOR COLLIMATED LIGHT INCIDENT ON THE SURFACE
C OF A LARGE SPHERE, WHICH IS MUCH LARGER THAN THE INCIDENT
C WAVELENGTH.  THIS FUNCTION ALLOWS GENERALIZED COMPLEX INDICIES
C OF REFRACTION ON BOTH SIDES OF THE INTERFACE (SURFACE OF THE
C SPHERE) USING THE "PAGE 60" REFLECTIVITY EQUATIONS.
C
C
C DISCUSSION:
C
C THE EQUATION FOR CALCULATING Se IS SIMPLY AN INTEGRAL, OVER A
C HEMISPHERE, OF THE SCALAR SUM OF THE PERPENDICULAR (f') AND
C PARALLEL (f") COMPONENTS OF REFLECTIVITY (THE SQUARED MAGNITUDE
C OF THE FRESNEL REFLECTION COEFFICIENT) FROM A DESCRETE INCIDENT
C RAY.  THIS EQUATION IS EASILY DERIVED BUT MAY BE FOUND AS
C EQUATION (21) ON PAGE 3046 OF THE BRUCE HAPKE PAPER,
C "BIDIRECTIONAL REFLECTANCE SPECTROSCOPY", IN JOURNAL OF
C GEOPHYSICAL RESEARCH, VOL. 86, NO. B4, PAGES 3039-3054, APRIL
C 10, 1981 (EQUATION (21) IS THERE REFERENCED TO KERKER (1969)). 
C ON PAGES 3046 AND 3047, BACKGROUND IS PROVIDED DESCRIBING HOW A
C SPHERE APPROXIMATES AN EQUANT PARTICLE THAT IS MUCH LARGER THAN
C THE WAVELENGTH, HOW A SPHERE WITH COLLIMATED INCIDENT LIGHT
C BEHAVES LIKE A SLAB WITH DIFFUSE INCIDENT LIGHT (ALTHOUGH THE
C EQUATIONS USED IN THIS FUNCTION-ROUTINE DID NOT REQUIRE THIS
C ANALOGUE FOR DERIVATION), AND HOW THE FINAL EQUATION FOR Se CAN
C BE EXPECTED TO BEHAVE UNDER CERTAIN COMMON CIRCUMSTANCES.
C
C THE OLDER TERMINOLOGY USED IN THE HAPKE (1981) EQUATION (21)
C MAY BE A BIT CONFUSING:  THERE, f' AND f" ARE CALLED "FRESNEL
C COEFFICIENTS", WHEN ACCORDING TO HAPKE'S "THEORY OF REFLECTANCE
C AND EMITTANCE SPECTROSCOPY", 2ND EDITION, 2012, PAGES 59 AND
C 60, f' AND f" SHOULD BE CALLED "REFLECTIVITIES".  REFLECTIVITY
C IS, IN FACT, THE SQUARED AMPLITUDE (REAL) OF THE "REFLECTION
C COEFFICIENT" (COMPLEX).  
C
C EQUATION (21) IS NOW COPIED HERE FROM HAPKE (1981):
C
C          a=PI/2
C     Se = SIG [ f'(a) + f"(a) ]sin(a)cos(a)da
C          a=0
C
C     WHERE:
C             Se    - EXTERNAL SURFACE SCATTERING COEFFICIENT
C             SIG   - INTEGRAL SYMBOL
C             a     - ANGLE OF INCIDENCE, THETA, WHICH IS THE
C                     ANGLE AT THE POINT OF INCIDENCE BETWEEN THE
C                     DIRECTION OF THE INCIDENT LIGHT AND THE
C                     DIRECTION OF THE PERPENDICULAR TO THE
C                     SURFACE.
C             f'(a) - PERPENDICULAR COMPONENT OF REFLECTIVITY,
C                     WHICH IS THE SQUARED MAGNITUDE OF THE
C                     PERPENDICULAR FRESNEL REFLECTION
C                     COEFFICIENT, AS A FUNCTION OF INCIDENCE
C                     ANGLE, a.
C             f"(a) - PARALLEL COMPONENT OF REFLECTIVITY, WHICH
C                     IS THE SQUARED MAGNITUDE OF THE PARALLEL
C                     FRESNEL REFLECTION COEFFICIENT, AS A
C                     FUNCTION OF INCIDENCE ANGLE, a.
C
C WHILE THIS INTEGRAL EQUATION APPEARS SUFFICIENT TO HANDLE
C GENERALIZED COMPLEX INDICIES OF REFRACTION ON BOTH SIDES OF THE
C INTERFACE, THE SUPPORTING EQUATIONS GIVEN WITH EQUATION (21)
C THAT YIELD REFLECTIVITIES (f' AND f") ONLY HANDLE REAL INDICIES
C OF REFRACTION.  THIS GIVES REASON FOR PAUSE, AS TO THE
C CORRECTNESS OF SIMPLY GENERALIZING THE EXPRESSIONS FOR f' AND
C f" TO INCLUDE THE FULL RANGE OF COMPLEX INDICIES OF REFRACTION.
C HOWEVER, AS IT HAS TURNED OUT SO FAR, IT APPEARS THAT EQUATION
C (21) IS SUFFICIENTLY GENERAL, BUT THE CALCULATION OF THE
C REFLECTIVITIES WHEN THE INDICES OF REFRACTION ARE COMPLEX IS
C QUITE A DIFFERENT MATTER.
C
C INDEED, IN HAPKE (2012), PAGE 72, A SHORT 1 PAGE INTRODUCTION
C TO MIE THEORY SUGGESTS THAT THE QUANTIFICATION OF SCATTERING BY
C A PERFECT, UNIFORM SPHERE IS IN GENERAL A VERY COMPLICATED AND
C PERHAPS FUTILE SUBJECT.  (IT SEEMS HOWEVER, USE OF A SPHERE
C THAT IS LARGE COMPARED TO THE WAVELENGTH SHOULD GREATLY
C SIMPLIFY MATTERS).  IN ANY CASE, HE REFERS US BACK TO KERKER
C (1969) -- AGAIN -- JUST AS HE HAD FROM EQUATION (21) IN HAPKE
C (1981).  WHAT MAY BE GLEANED FROM THIS IS THAT WE MIGHT RUN
C INTO PROBLEMS WHEN ATTEMPTING TO GENERALIZE f' AND f" FROM REAL
C TO COMPLEX INDICES OF REFRACTION.  EXAMINATION OF THE
C PROLIFERATION OF EQUATIONS ON PAGES 59 AND 60 OF HAPKE (2012)
C SUPPORTS THIS NOTION.
C
C IN FACT PRELIMINARY TESTS SHOW THAT THE VALUES OF GENERALIZED
C REFLECTIVITIES GIVEN BY EQUATIONS (4.44) - (4.49) ON PAGE 60 OF
C HAPKE (2012) MAY SIGNIFICANTLY EXCEED 1 WHEN THE MEDIUM 1 INDEX
C OF REFRACTION IS GREATER THAN THAT OF MEDIUM 2 -- THAT IS, WHEN
C A CRITICAL ANGLE EXISTS; AND THIS RAISES CONCERNS ABOUT THE
C GENERAL APPLICABILITY AND EVEN THE CORRECTNESS OF THE PAGE 60
C EQUATIONS.  MOREOVER, EXAMINATION OF THE PAGE 60 EQUATIONS
C SHOWS THAT THE ONLY INDEX OF REFRACTION VALUES USED ARE NR AND
C NI, WHICH ARE RESPECTIVELY THE REAL AND IMAGINARY PARTS OF
C N2/N1, WHICH IN TURN IS THE RATIO OF THE COMPLEX MEDIUM 2 OVER
C THE COMPLEX MEDIUM 1 INDEX OF REFRACTION.  IN PRODUCING THIS
C RATIO, THE COMPLEX ARGUMENT IS LOST.  IN OTHER WORDS, WHILE NR
C AND NI CONTAIN THE ANGULAR SEPARATION IN THE COMPLEX PLANE
C BETWEEN N1 AND N2, THEY DO NOT CONTAIN THE ANGULAR LOCATION IN
C THE COMPLEX PLANE OF THE PAIR OF INDICES.  ANOTHER WAY TO STATE
C THIS IS THAT ANY GIVEN PAIR OF VALUES, NR AND NI, CAN BE
C PRODUCED BY AN INFINITE NUMBER OF PAIRS OF INDICES OF
C REFRACTION.
C
C NEVERTHERLESS, WHEN NR > 1 (THE INDICES ARE NOT INVERTED) AND
C THE COMPLEX ARGUMENT OF N1 IS ASSUMED TO BE ZERO (N1 HAS NO
C IMAGINARY PART), THE PAGE 60 EQUATIONS SEEM TO WORK PROPERLY
C WHEN PLUGGED INTO EQUATION (21).  THIS CAN BE CHECKED NOTING
C THAT EQUATION (21) FROM HAPKE (1981) OCCURS AGAIN IN HAPKE
C (2012), PAGE 87, AS EQUATION (5.36); AND ITS SOLUTIONS FOR
C VARIOUS NI ARE PLOTTED IN FIGURE 5.11 ON PAGE 88.  FIGURE 5.11
C THEN GIVES A GOOD(?) SET OF REFERENCES AGAINST WHICH TO CHECK
C EQUATION (21), INCLUDING THE NI=0, 1, 2, 3, & 4 LEVELS.  UNDER
C THE NR > 1 AND N1 REAL CIRCUMSANCE, THE PAGE 60 REFLECTIVITIES
C PLUGGED INTO EQUATION (21) OR (5.36) YIELD Se LINES NEARLY (BUT
C NOT EXACTLY) IDENTICAL TO FIGURE 5.11; AND THE NI=0 LEVEL
C MATCHES THE PLOT GIVEN IN HAPKE (1981), FIGURE 6, ON PAGE
C 3047.  THIS APPEARS TO BE A NICE CONFIRMATION OF THE PAGE 60
C EQUATIONS.  HOWEVER, BECAUSE THE PAGE 60 EQUATIONS ARE NOT
C GENERAL AND THEY YIELD OBVIOUSLY INCORRECT CURVES FOR INVERTED
C COMPLEX INDICES OF REFRACTION, WE MUST CONSIDER OTHER SETS OF
C EQUATIONS.  
C
C AS AN ALTERNATIVE TO THE PAGE 60 EQUATIONS, WE CAN DERIVE A SET
C OF REFLECTIVITIES FROM EQUATIONS (4.42A), (4.42B) AND (4.43),
C WHICH ALL APPEAR ON PAGE 59 OF HAPKE (2012); AND WE CALL THESE
C THE "PG 59" EQUATIONS FOR REFLECTIVITY.  THE PAGE 59 EQUATIONS
C NEVER YIELD REFLECTIVITIES GREATER THAN 1; AND THE CORRECT
C COMPLEX ARGUMENT IS INCORPORATED INTO THE RESULT.  THE PROBLEM
C IS THAT THEY YIELD RESULTS DIFFERENT FROM THE PAGE 60 EQUATIONS
C EVEN WHEN THE COMPLEX ARGUMENT OF N1 IS ZERO AND NR > 1. 
C MOREOVER, VALUES OF Se CALCULATED FOR WATER ICE USING THE PG 59
C EQUATIONS YIELD RESULTS THAT DIFFER SIGNIFICANTLY IN PLACES
C (WHEN NR IS SLIGHTLY GREATER THAN OR SLIGHTLY LESS THAN 1) FROM
C EQUIVALENT VALUES DERIVED BY OTHER MEANS; WHILE THE PAGE 60
C EQUATIONS ARE CLOSER.  CONSEQUENTLY, IT IS NOT CLEAR THAT THE
C PAGE 59 EQUATIONS ARE ANY MORE ACCURATE THAN THE PAGE 60
C EQUATIONS.
C
C FURTHERING THE CONCERNS WITH THE PAGE 59 EQUATIONS, THERE MAY
C BE PROBLEMS WITH GENERALIZING f' AND f" BY PLUGGING COMPLEX
C INDICES OF REFRACTION INTO EQUATIONS THAT HAVE BEEN DESIGNED
C AROUND REAL-ONLY INDICES.  THIS IS BECAUSE THE REAL AND THE
C IMAGINARY PARTS OF A COMPLEX INDEX OF REFRACTION ARE OF
C PHYSICALLY DIVERGENT KINDS, UNLIKE THE REAL AND IMAGINARY PARTS
C OF, FOR INSTANCE, A TRAVELING-WAVE EXPRESSION.  IN THE LATTER
C CASE, A SINGLE COMPLEX GOVERNING EQUATION CAN BE BROKEN INTO A
C COUPLET OF REAL GOVERNING EQUATIONS THAT BOTH HAVE EQUIVALENT
C FORMS.  BUT THE REAL PART OF A COMPLEX INDEX OF REFRACTION HAS
C TO DO WITH SPEED WHILE, THE IMAGINARY PART HAS TO DO WITH
C ABSORPTION; EQUATIONS GOVERNING SPEED AND ABSORPTION ARE NOT OF
C EQUIVALENT FORMS.  ONE SHOULD NOT THEREFORE EXPECT THE FRESNEL
C EQUATIONS TO GENERALIZE EASILY TO COMPLEX INDICIES OF
C REFRACTION.
C
C SO THEN, THE CRITICAL DETERMINATION SEEMS TO BE IN HOW TO
C CALCULATE THE PERPENDICULAR AND PARALLEL REFLECTIVITIES, f' AND
C f".  THIS FUNCTION ROUTINE USES THE PAGE 60 EQUATIONS BY
C CALLING FUNCTION ROUTINES f_Rperp.f AND f_Rpara.f.  FOR
C COMPARISONS, A COUNTERPART TO THIS FUNCTION SUBROUTINE HAS BEEN
C WRITTEN, CALLED f_Se_pg59.f, WHICH USES THE PAGE 59 EQUATIONS
C BY CALLING rsp2.f.
C
C
C FUNCTION AND ARGUMENT DESCRIPTIONS:
C
C FUNCTION:
C   F_SE_PG60 - REAL*4.  THE EXTERNAL SURFACE SCATTERING
C            COEFFICIENT (Se) FOR COLLIMATED LIGHT INCIDENT ON
C            THE SURFACE OF A LARGE SPHERE, WHICH IS MUCH LARGER
C            THAN THE INCIDENT WAVELENGTH. 
C
C INPUT ARGUMENTS:
C   N1R4   - REAL*4.  THE REFRACTIVE INDEX IN MEDIUM 1
C            (INCIDENT SIDE), REAL PART.
C   N1I4   - REAL*4.  THE REFRACTIVE INDEX IN MEDIUM 1
C            (INCIDENT SIDE), IMAGINARY PART.
C   N2R4   - REAL*4.  THE REFRACTIVE INDEX IN MEDIUM 2
C            (TRANSMITTING SIDE), REAL PART.
C   N2I4   - REAL*4.  THE REFRACTIVE INDEX IN MEDIUM 2
C            (TRANSMITTING SIDE), IMAGINARY PART.
C   DX4    - REAL*4.  THE APPROXIMATE INCREMENT <DEG> TO USE FOR
C            CALCULATING THE INTEGRAL.  KEEPING IN MIND THAT THE
C            INTEGRATION LIMITS ARE 0 TO 90 DEGREES, THE SMALLER
C            DX WILL LEAD TO A GREATER PRECISION BUT MORE TIME
C            TAKEN FOR THE CALCULATION.
C
C            TESTING SHOWS THAT THE INCREMENTAL IMPROVEMENT IN
C            PRECISION IS SMALL WHEN DX=1 DEGREE.  WHEREAS, WHEN
C            DX=9 DEGREES, THE INCREMENTAL IMPROVEMENT IS GREAT. 
C            THEREFORE, IF PRECISION IS NEEDED, USE DX=1 DEGREE;
C            IF SPEED IS NEEDED, USE DX=9 DEGREES.  ANYTHING
C            LARGER THAN 9 DEGREES WOULD NOT BE RECOMMENDED.
C
C
C FUNCTION F_SE_CXIR_PG60_REFLEC WRITTEN BY ROB BRACKEN, USGS.
C DIGITAL Visual Fortran, F90 version 5.0, DEC copyright 1997.
C VERSION 1.0, 20130703 ( ORIGINAL CODE
C                                USING EQUATIONS AS CITED ABOVE).
C
C FUNCTION F_SE_PG60 WRITTEN BY ROB BRACKEN, USGS.
C DIGITAL Visual Fortran, F90 version 5.0, DEC copyright 1997.
C VERSION 2.0, 20131122 ( MODIFIED CODE FOR PLUG-IN TO RADTRAN).
C
C

      function f_Se_pg60(n1r4,n1i4,n2r4,n2i4,dx4)
C
C     FUNCTION
      real*4 f_Se_pg60
C
C     INPUT ARGUMENTS
      real*4 n1r4,n1i4,n2r4,n2i4,dx4
C
C
C     CONVERSION OF ARGUMENTS TO REAL*8
C
C     REAL*8 VERSIONS OF THE INPUT ARGUMENTS
      real*8 n1r,n1i,n2r,n2i,dx
C
C
C     LOCAL DECLARATIONS
C
C     INTERNAL FUNCTION VALUE
      real*8 se
C
C     PI CONVERSION FACTORS
      real*8 PIE,D2R,R2D
      parameter( PIE = 3.1415 92653 58979 32384 62643d0 )
      parameter( D2R = PIE/180.d0 , R2D = 180.d0/PIE)
C
C
C     FUNCTION F_rPERP(THETA,LNOP ,N1R,N1I,N2R,N2I    ,LNON,NR,NI
C    &                                  ,G1,G2,SINT,COST ,TANPHI)
C       FUNCTION
      real*8 f_Rperp
C       INPUT ARGUMENTS
      real*8 theta
      integer*4 lnop
C     real*8 n1r,n1i,n2r,n2i
C       INPUT/OUTPUT ARGUMENTS
      integer*4 lnon
      real*8 nr,ni
C       OUTPUT ARGUMENTS
      real*8 g1,g2,sint,cost
      real*8 tanphi
C
C
C     FUNCTION F_rPARA(THETA,LNOP  ,NR,NI  ,G1,G2,SINT,COST
C    &                                                   ,TANPHI)
C       FUNCTION
      real*8 f_Rpara
C       INPUT ARGUMENTS
C     real*8 theta
C     integer*4 lnop
C     real*8 nr,ni
C     real*8 g1,g2,sint,cost
C       OUTPUT ARGUMENT
C     real*8 tanphi
C
      real*8 tanph2
C
C
C     BLOCK-BY-BLOCK INTEGRATION DECLARATIONS
      real*8 dt,dt2
      integer*4 nn
      real*8 rpe,rpa
C
C
C
C CONVERT REAL*4 INPUT ARGUMENTS TO REAL*8
C
      n1r = dble(n1r4)
      n1i = dble(n1i4)
      n2r = dble(n2r4)
      n2i = dble(n2i4)
       dx = dble( dx4)
C
C
C BLOCK-BY-BLOCK INTEGRATION (NUMERICAL RECIPES PG 788)
C
C     SET INITIAL VALUES FOR INTEGRATION
      se=0.d0
      nn=(90.d0/dx+0.5d0)
      dt=(90.d0/nn)*D2R
      dt2=dt/2
C
      lnop=1
      lnon=0
C
C
C     PERFORM BLOCK-BY-BLOCK INTEGRATION
      do i=1,nn
C
C       CALCULATE VALUES FOR CURRENT BLOCK
        theta=dt*i-dt2
        rpe=f_Rperp(theta,lnop ,n1r,n1i,n2r,n2i    ,lnon,nr,ni
     &                                  ,g1,g2,sint,cost ,tanphi)
        rpa=f_Rpara(theta,lnop  ,nr,ni  ,g1,g2,sint,cost
     &                                                   ,tanphi)
C
C       CALC CURRENT BLOCK OF INTEGRAL & ADD IT TO RUNNING TOTAL
c        se=se + (rpe+rpa)*sint*cost
        se=se + (dmin1(rpe,1.d0)+dmin1(rpa,1.d0))*sint*cost
      enddo
      se=se*dt
C
C
C
C EXIT PROCEDURE
C
  990 f_Se_pg60=sngl(se)
      return
      end

