	subroutine redspr (ikey, lun, ier)
	implicit integer*4 (i-n)

#ccc  version date: 04/05/85
#ccc  author(s): Roger Clark & Jeff Hoover
#ccc  language:  Ratfor
#ccc
#ccc  short description: This routine reads a specpr format data
#ccc    file and puts the data into the label 1 common block according to
#ccc    flags.  Multiple records of data are read and combined into one
#ccc    large spectrum.This program has been modified from redfil by
#ccc    eliminating all tape manipulation routines.
#ccc  algorithm description: none
#ccc  system requirements:   none
#ccc  subroutines called:
#ccc          devsta,crtin,posfil,ertyp,dread,newsta,rewinf
#ccc  argument list description:
#ccc        arguments: ikey,lun,ier
#ccc  parameter description:
#ccc  common description:
#ccc  message files referenced:
#ccc  internal variables:
#ccc  file description:
#ccc  user command lines:
#ccc  update information:
#ccc  NOTES:
#ccc
#ccc  Randall Dailey 05/24/2004
#ccc    Changed to call bytorder after reads on little endian systems
#################################################################
#                                                               #
#       read file routine                                       #
#                                                               #
#       arguments                                               #
#         ikey          record nember to be read.               #
#         lun          logical unit to read from.               #
#         ier         error flag to calling routine             #
#                                                               #
#################################################################


	include  "../src.specpr/common/spmaxes"
	include  "../src.specpr/common/label1"
	include  "../src.specpr/common/lundefs"
	include  "../src.specpr/common/iocontrol"

	integer*4 input(384)
	equivalence (input,icflag)

	dimension codata(383)
	character*1532 tdata
	equivalence (codata, iobuff(2))
	equivalence (tdata, iobuff(2))

	integer*4	ier
	integer*2	ibit, chkbit

	integer*4	revbytes

# revbytes =1 reverses bytes on the binary data.  By default it is zero
# byte order is that on HP, Sun sparc machines.
#  - Roger N. Clark 2/18/2001

                revbytes = 0
#LINUX          revbytes = 1
	
	maxrec = 999999
	rferfl(1)=1
	rferfl(2)=0
	ier = 0

	if (ikey<1) ikey= 1
	if (ikey>maxrec) {
		write (ttyout, 11) ikey, maxrec
11		format (' file request',i5,' greater than ', i6, /)
	}

	key = ikey + 1
	read(lun,rec=key,iostat=ier) iobuff

	if (revbytes == 1) {
		call bytorder (iobuff,1)
	}


	if (ier != 0) {
		call ertyp('redspr ',lun,ier)
	}


# this was first record of potential multiple record spectrum;
#	if bit 0 of flag is 1 then this is a continuation record,
#	not the first.  Issue error message and exit

	ibit=0
	if (chkbit(iobuff(1), ibit) == 1) {
		if (rferfl(1) == 1) write (ttyout, 20) ikey
20		format (' ERROR: continuation bit set on record',i5,' but this',
			' should have been the ', /,
			'first record of requested data set',/,
			'        press return to exit read routine',
			/)
		call crtin
		rferfl(2) = 1
		ier = 1
		return
	}
	
# copy input buffer to label1 common (input)

	do i = 1, 384
		input(i) = iobuff(i)

#debug:
#	write (ttyout,402) itchan
#402	format (1x,'read segment 1: itchan=',i5)

# if itchan > 256 then read in succeeding records if data record
# if itxtch > 1476 then read in succeeding records if text record

	ibit = 1
	if (chkbit(icflag,ibit) == 0) {
		if (itchan > maxchn) itchan = maxchn
		if (itchan < 1) itchan = 1
		irect = int((float(itchan) -256.0)/383.0 +0.999)
	} else {
		if (itxtch > maxtxt) itxtch = maxtxt
		if (itxtch < 1) itxtch = 1
		irect = int((float(itxtch) -1476.0)/1532.0 +0.999)
	}

	if (irect >= 1) {
		do j = 1, irect {

			ikey = ikey +1
			ier = 0
			if (ikey<1) ikey= 1
			if (ikey>maxrec) {
				write (ttyout, 11) ikey, maxrec
				ier=1
				call crtin
				ikey=1
				return
			}

			key=ikey+1
			read(lun,rec=key,iostat=ier) iobuff

			if (revbytes == 1) {
				call bytorder (iobuff,1)
			}
	
# debug:
#			jseg = j + 1
#			write (ttyout,401) ikey, itchan, jseg
#401	format(1x,'reading continuation record',i5,' channels',i5,
#                   ' segment=',i4)
#
			if (ier != 0) {
				call ertyp('redspr ',lun,ier)
			}

# check continuation bit then copy data to label1 common

			ibit=0
			if (chkbit(iobuff(1), ibit) == 0) {
				write (ttyout, 30) ikey
30 			format (' ERROR on read at continuation record',i5, /,
		   '       continuation bit not set, press return to exit')
				call crtin
				ier = 1
				return
			}

			ibit =1
			if (chkbit(iobuff(1),ibit) == 0) {
#
				isegm = 256 + (j-1)*383
				do m = 1, 383
					data(isegm +m) = codata(m)

			} else {
				isegm = 1476 + (j-1)*1532
				itext(isegm:isegm+1532) = tdata
			}
		}
	}


#****************
	ibit = 1
	if (chkbit(icflag,ibit) == 0) {
		do i=1,itchan{
			if (data(i)>-1.23001e34 && 
				data(i)<-1.22999e34) data(i) = -1.23e34
		}

# delete points not in spectrum to clear buffer

			ii = itchan+1
			if (itchan > maxchn) write (6,
					"('Channels too big:',i9)") itchan
			if (ii <= maxchn) {
				do i = ii, maxchn {
					data(i) = -1.23e34
				}
			}

	}
	return
	end
