.\" use ms macros
.\" this header is for putting the page numbers at the bottom of the page
.\" set line length, page offset, vertical spacing
.nr LL 6.3i
.ll 6.3i
.nr PO 1.0i
.po 1.0i
.nr VS 12
.vs 12
.\" set header and footer margins (default is 1.0i)
.nr FM 1.00i
.fm 1.00i
.nr HM 1.00i
.hm 1.00i
.\" set no date here, MUST be before CF definition, because ND sets CF
.\" set date, so don't do .ND
.\" LH CH RH are left, center, right header strings
.\" LF CF RF are left, center, right footer strings
.\" default is CH is defined as: .ds CH "\(hy \\n(PN \(hy
.ds LH "SPECPR Users' Manual
.ds CH
.ds RH "Page 13.\\n(PN
.\" setup complete
.nf
SPECPR Users' Manual                                                   Page 13.1













.ce
.B
CHAPTER 13
.R





.ce
.B
PLOT ROUTINES FOR WORK AND PUBLICATION
.R




.fi
.bp
.B
13.1  Introduction
.R
.PP
The specpr hardcopy plot routines are designed to provide publication
quality plots for general x-y data sets.  Specpr builds two
intermediate files: a vector file and a text file.  The files are
plotter device independent.  Specpr then starts a Unix daemon
process that reads the files and plots the data on a specific
plotter.  The daemon process is device dependent.  While some users
have written programs to use several different plotters and even
laser printers, the most commonly used plotter is an
HP7550-compatible plotter.  This chapter is specific to the
HP-compatible plotters, but will work in general for all other
plotters so far implemented.
.PP
The plot routines are called from Program Operations by
typing a

.in 14n
.B
p
.R
.in 0n

command.
.PP
When you first enter the routine, the first command will list the
available plotters.  This may be site dependent.


.B
13.2  Plotting Mode Type
.PP
The first step in setting up a plot is to select the plot mode.
Type

.in 14n
.B
w
.R
.in 0n

to plot in value versus wavelength,

.in 14n
.B
n
.R
.in 0n

to plot in value inverse wavelength.  In this case, you specify a
wavelength set in microns and the plot routines convert to
wavenumber where wavenumber increases to the right.
To plot in wavenumber, as above, but with wavenumber increasing to
the left (reverse of the above mode), type an

.in 14n
.B
r
.R
.in 0n

command.
If you want to use your own horizontal axis label, type

.in 14n
.B
y
.R
.in 0n

(the plot will be linear).  You will then be asked to type in the
horizontal axis label (24 characters).  For example, you might type:

.in 14n
.B
TIME (SECONDS)
.R
.in 0n

or whatever your data correspond to.  Thus, you may do any kind
of one-dimensional array processing you wish.


.B
13.2.1 User-selected wavelength limits
.R
.PP
If you type only a letter for the plot mode, the horizontal axis is
scaled to the range covered by all the wavelength sets used in the
generation of the plot.  However,
you may select the wavelength limits for the plot, regardless of
the wavelength sets used.  When you type in the "w" for wavelength
mode (or n, r, or y), also type (on the same line) the minimum
and maximum wavelengths for the plot.  Type in wavelengths 
the inverse wavelength modes (n and r) also.  Example:

.nf
.in 14n
.B
w 0.325        2.60
n 0.325        2.60
r 0.325        2.60
y 0.325        2.60
.R
.in 0n
.fi

The actual limits on the plot will be 2% greater than the range
(maximum-minimum) on each side (see section 13.5 for details).
The left bound is then minimum minus 2% of the
maximum-minimum range, and the right bound is the maximum plus 2%
of the maximum-minimum range.
.PP
You can suppress the addition of the 2% by adding the option

.in 14n
.B
n
.R
.in 0n

after the limits.  For example,

.in 14n
.B
w 0.325  2.60
.R
.in 0n

would produce actual limits of 0.2795 to 2.6455.  However,

.in 14n
.B
w 0.325  2.60n
.R
.in 0n

would keep the actual limits at 0.325 and 2.60.
.PP
To exit the plot routine, type an

.in 14n
.B
e
.R
.in 0n
or
.in 14n
.B
x
.R
.in 0n

command anywhere in the routine.


.KS
.B
13.3  Vertical Axis Label
.R
.PP
Several vertical scale labels are displayed for you to select.  They are
numbered 1 to n, where n is currently 8.  To select one of these, type
in the number.  If you wish to type in your own label, type the number
(currently number 9) that says "type in your own label," and you will be
instructed to type in a label of not more than 60 characters.  If you
wish to plot the vertical axis in log (base 10) of the input data, type

.in 14n
.B
10
.R
.in 0n
.KE

and you must type in your own vertical axis label.  The program
will then proceed to the Delete From All Spectra section.  Type

.in 14n
.B
e
.R
.in 0n
or
.in 14n
.B
x
.R
.in 0n

to return to the beginning (section 13.1).


.KS
.B
13.4  Delete From All Spectra
.R
.PP
If, from all the spectra you are going to plot, you wish to delete
one or more channels common to all, type a

.in 14n
.B
d
.R
.in 0n
.KE

command.
You will then be instructed to type in the channels that will be
deleted from all spectra to be plotted.  At least one space should
be left between each pair of channels, and more than one line can be
used for input.  All channels may be deleted if desired.  When
you are through, type

.in 14n
.B
c
.R
.in 0n

to continue to the scale section.  Type

.in 14n
.B
e
.R
.in 0n
or
.in 14n
.B
x
.R
.in 0n

to return to the beginning (section 13.1).  When typing in a
sequence of channels, you may give the beginning channel, a

.in 14n
.B
t
.R
.in 0n

and the end channel.  For instance, to delete channels 1, 2, 3, 4,
5, 6, 7, 8, 15, 16, 17, 23, and 24, you could type

.in 14n
.B
d1t8 15t17 23 24c.
.R
.in 0n


.KS
.B
13.5  Scale of Plot
.R
.PP
The vertical scale of the plot is selected by the user.  Type in
the lower and upper bounds of the plot.  The plot size is 13.5
centimeters (vertical axis) by 21.7 centimeters (horizontal
axis) for the data plot area on the HP plotter.  However, the plot
size does vary somewhat with other plotters.
.KE
.PP
If your data are to be plotted in log space on the vertical axis,
the lower and upper bounds should be input as ordinary numbers.
The program will convert the scale limits and data to logs.  The
scale is then labeled as the log of the number.  Type

.in 14n
.B
e
.R
.in 0n
or
.in 14n
.B
x
.R
.in 0n

to return to the beginning of the plot routines (section 13.1);
otherwise, the program will go to the Plot Scale Factors section
(section 13.6).


.KS
.B
13.6  Plot Scale Factors
.R
.PP
Next you are asked to enter the plot horizontal and vertical
scaling factors.  These factors must be less than 1.0 and scale the
size od the data area of the plot.  Thus if the original size of the
plot was 17 centimeters high, a vertical scale factor of 0.5 would
make it 8.5 centimeters.  These scale factors do not affect the text
or the text size.
.KE


.KS
.B
13.7  Data Set Input and Options
.R
.PP
The data sets to be plotted are input as the file ID (v, w, u, y, or d),
the record number, and the options.  For all data sets entered, the
wavelength set must be specified.  If it is not, unpredictable plots
can occur.  A maximum of 50 spectra may
be plotted at one time.  These may be all on one graph or
separated into many plots by an option request.  The options are
listed below.
.KE

.in 14n
.ti -10n
Option\ B  means to plot symbols as Black (assuming the black pen is
used on HP compatible plotters), the same color as the axes labels.
The default is to use the same pen color as the data.

.ti -10n
Option\ c  means to Connect the data points.  If the wavelengths are not in
sequence, or a if channel has been deleted, the points involved are
not connected.

.ti -10n
Option\ C  means to Always Connect the data points.  This option permits the
wavelengths to be NOT in sequence, but will connect them anyway.

.ti -10n
Option\ d  means to delete points from this data set only (as opposed to
delete from all data sets as in section 13.4).  The program
will ask for channels to be typed in when it is ready.  More than
one line may be used to input the channels to be deleted.
When you are finished entering channels,
type

.B
          c
.R

to continue.

.ti -10n
Option\ e  is include Errors.

.ti -10n
Option\ E  is include Errors, but only when the error bars are large
enough to be recognized on the plot.

.ti -10n
Option\ g  means the spectrum after this one is to be plotted on a new
graph.  Thus, 50 spectra may be plotted on a single graph
(overlaid), or they may be plotted singly or any
combination.  The g (new Gould plot) selects when a new plot
is to begin.  The "g" works the same for non-Gould plotters also.

.ti -10n
Option\ l  followed by a number 1 through 8 selects the line color
for the plot.  The line color for HP-compatible plotters is the pen
number.  The default is size 1.

The line color for some implementations is device daemon dependent.
For the Gould electrostatic plotter this number represents the line
thickness.  the axis is fixed at 3.  The number 1, 3, 5, or 7 is the
width of the line in Gould units.  Size 1 is about 1/200 of an inch
(0.127 mm).  The line size changes error bars and the line connecting
points.

.ti -10n
Option\ L  is the Line type.  For HP-compatible plotters it varies
from solid to various dot and line patterns.  See Figure 13.7.1 for
specific examples.

.ti -10n
Option\ m  More copies:  In the options, specify "m" and the number of copies
desired (1 to 9) default=1.  Note that you need this option only on
the last spectrum to be put on the plot.

.ti -10n
Option\ n  means that, if a point lies outside the lower or upper bound, it
should be deleted.  If this specification is not given, the point
will be plotted at the limit of the graph.

.ti -10n
Option\ o  means to offset the data, followed by the amount to offset.
You can use any positive or negative number.  This number is added
to the data before it is plotted.  For example to offset data set
v23 with its wavelength set v22, you could type:

.B
           v23V22o2.2
.R

to offset by 2.2 data units.

.ti -10n
Option\ p  followed by a number is the point size.  This number can be 0 to
5.  If the number is zero, no point will be plotted.  Point size 1 is
about 1.27mm on a side, size 2 is twice this, size 3 is three
times, etc.  Note, if point size zero is specified and points are
not connected, no data will be plotted, and you will have a blank
plot!  A line drawing can be made by specifying point size zero and
connecting points.  The default point size varies with the total
number of channels per spectrum.  It is size 3 for 30 channels or
less, size 2 for 31 to 100 channels, and size 1 for more than 100
channels.  The symbol type changes with each spectrum plotted.
See Figure 13.7.2.

.ti -10n
Option\ r  Because mistakes are bound to happen when typing in all these
data sets, you may return to the last step for re-entering your
data.  This is done by typing an "r" in place of a file ID and
record number.  Example:  You type in the spectra

        1)  "v23eV2p3"
        2)  "v29eV2p4"
        3)  "v30p1c"
        4)  "v33V5".

You now notice the step #3 should have been "v31V3p1c".  You are
at step 5:  you type "r"; the computer says

        "RETURN TO 4; CONTINUE".

You then type "r" again, and the computer responds

        "RETURN TO 3; CONTINUE".

You may then retype step 3 (and also all steps after 3).  You
may not return to a step before the first data set entered (if you
need to, you must "e" or "x" to exit).

.ti -10n
Option\ s  Symbol type:  To change symbol type, specify "s" and the symbol
number (1 to 8).  See Figure 13.7.2.  The symbol size is
given by the "p" specification (point symbol size).  The symbol
type is incremented for each spectrum input and is reset to 1 for
each new plot ("g" specification).

.ti -10n
Option\ t  means to include text on the graph.  Text may be written as 15
sets of 70 characters per set for each spectrum entered.  The
text position is given in centimeters [horizontal direction (x),
then vertical (y)] from the lower left-hand corner of the axes of
the plot.  After the x and y position, input the text angle
(90\(de is horizontal and 0\(de is vertical)
and then the text to be added.  When all text is entered, type a

.B
       c
.R

to continue to the next data set.

Symbols may be plotted using the text mode.  Instead of x, y,
degrees, text, you enter 

       s <symbol type> <size> x y

where <symbol type> is the symbol described under the "s" option.
The symbol size is also described under the "s" option.

Terminate entry of the text mode and continue entering data sets by
typing a

.B
       c
.R

command.

.ti -10n
Option\ V, W, D, U or Y  followed by a record number sets
the wavelength set to be used (the horizontal axis values).

.in 0n
.PP
.B
Notes on Text entry:
.R
You may also return to the previous text entry using the "r"
specification as with the data set input.  You may not return to a
previous entry before text entry 1.  If you have an error in a
previous file entry, type "c" to continue to next step after text
entry; then return to the last data set input as described above.
.PP
The specpr plot routines allow subscripting, superscripting,
backspacing and greek and math characters in the
text.  Special characters are used to enter
the different modes and can be used wherever text is written on
the plot (horizontal or vertical axis labels or other text).  The
characters are:

.KS
.nf
.in 5n
.B
  Character                      Effect
.R
\e (Backslash)            Backspace to previous character
\e{ (Left Brace)          Go into subscript mode
} (Right Brace)          Go into superscript mode
@ (At sign)              End last scripting mode
! (Exclamation Point)    Toggle greek/normal mode (see table 13.7.1)
| (Vertical Bar)         Toggle math/normal mode (see table 13.7.2)

NOTE:  the \\\\ is necessary before "{" because these brackets are used by
the command interpreter for variable parsing (section 2.6).  The "\\"
escapes the "{" so that it is not interpreted by the command line
variable parser.
.in 0n
.fi
.KE


.KS
.in 20n
.nf
   Table 13.7.1

.B
Greek character set
.R
--------------------
\(*A \(*a  A a    \(*N \(*n  N n
\(*B \(*b  B b    \(*C \(*c  C c
\(*G \(*g  G g    \(*O \(*o  O o
\(*D \(*d  D d    \(*P \(*p  P p
\(*E \(*e  E e    \(*R \(*r  R r
\(*Z \(*z  Z z    \(*S \(*s  S s
\(*Y \(*y  Y y    \(*T \(*t  T t
\(*H \(*h  H h    \(*U \(*u  U u
\(*I \(*i  I i    \(*F \(*f  F f
\(*K \(*k  K k    \(*X \(*x  X x
\(*L \(*l  L l    \(*W \(*w  W w
\(*M \(*m  M m
--------------------
.in 0n
.fi
.KE

.KS
Example: 1.04\(*mm would be entered as:

.in 14n
.B
1.04!m!m
.R
.in 0n
.KE


.KS
.nf
.in 6n
                       Table 13.7.2

.B
                    Mathematical Symbols
.R
--------------------------------------------------------------
A   infinity (\(if)                   _     _
B   improper superset (\(ip)          a   \(ua
C   proportional (\(pt)               b   \(da
D   union (\(cu)                      c   section (\(sc)
E   root extender (\(rn)              d   @
F   bell (\(bs)                       e   double dagger (\(dd)
G   plus or minus (\(+-)              f   |
H   less than or equal to (\(<=)      g   improper subset (\(ib)
I   greater than or equal to (\(>=)   h   \\\\
J   square root (\(sr)                i   circle (\(ci)
K   terminal sigma (\(ts)             j   partial derivative (\(pd)
L   integral sign (\(is)              k   empty set (\(es)
M   subset (\(sb)                     l   {
N   superset (\(sp)                   m   }
O   intersection (\(ca)               /   /
P   not (\(no)                        "   "
Q   clover leaf (\(ct)                #   #
R   angstrom (A\(de)                   '   '
S   gradient (\(gr)                   +   +
T   times (\(mu)                      -   -
U   divide (\(di)                     *   *
V   identically equal (\(==)          <   <
W   approximately equal (\(~=)        =   =
X   not equal (\(!=)                  >   >
Y   \(<-                              ^   ^
Z   \(->                              `   `
--------------------------------------------------------------
.in 0n
.fi
.KE

.PP
It was assumed that these characters would not need to be printed
so they have been reserved for the above special use.  Backslash
can be used to cause characters to be overprinted.  An "@" (at sign)
terminates the last use of a brace.  All characters in between
are printed in script mode.

.KS
Examples:

.nf
.in 14n
        A\e{1@	Will print as A\d1\u

        SAM\e\e\e___    Will print as S_A_M_

        X}2@-Y	Will print as X\u2\d - Y
.in 0n
.KE


.KS
.PP
Typing

.in 14n
.B
e
.R
.in 0n
or
.in 14n
.B
x
.R
.in 0n

in place of a file ID will cause the program to return to the beginning
of the routine (section 13.1).
.KE

Typing

.in 14n
.B
b
.R
.in 0n

will begin building the vector and text files
on the disc.  As soon as these files are complete, specpr starts the
plot daemon job and returns for more input.  Thus while the plotter
is plotting, you may do other tasks, including creating more
plots.
