.\" use ms macros
.\" this header is for putting the page numbers at the bottom of the page
.\" set line length, page offset, vertical spacing
.nr LL 6.3i
.ll 6.3i
.nr PO 1.0i
.po 1.0i
.nr VS 12
.vs 12
.\" set header and footer margins (default is 1.0i)
.nr FM 1.00i
.fm 1.00i
.nr HM 1.00i
.hm 1.00i
.\" set no date here, MUST be before CF definition, because ND sets CF
.\" set date, so don't do .ND
.\" LH CH RH are left, center, right header strings
.\" LF CF RF are left, center, right footer strings
.\" default is CH is defined as: .ds CH "\(hy \\n(PN \(hy
.ds LH "SPECPR Users' Manual
.ds CH
.ds RH "Page 8-f22.\\n(PN
.\" setup complete
.nf
SPECPR Users' Manual                                            Page 8-f22.1


.B
F22: Graph Digitization using a Tablet                     Alias: digi[tize]
.R
.PP
This routine is a graphics digitization program.
.B
Note: this routine is device-specific and must be tailored
specifically for your site; see your system administrator for
details).
.R
.PP
This program asks the user to define a graph by digitizing the
graph limits.  Then it accepts points from the tablet that are within
the limits of the graph and converts the x and y values into
data values as defined by the graph.
If a digitized point is outside the bounds of the graph, the
program will say so and ask if you want to redo the point, begin
over, write the data or exit.
.PP
When you are finished digitizing, the program will prompt you for the
file id (v, w, d, u, or y).  The file must have positive protection set.
The program will first write
the x data values and than the y values in the following record.  The
protection is updated as appropriate.
.PP
To run f22, type

.in 14n
.B
f22
.R
.in 0n

from math operations.  The program will
return with the title page of f22.

Press return to continue.
.PP
Digitize the upper left bound of the graph, lower left bound
(origin), and the lower right bound of the graph.  The program
will return with the values of the points in tablet coordinates,
the amount that the points are off perpendicular, and the angle
between the two axes.  If these values are acceptable type "yes".
.PP
The program will rotate the axis should it be not exactly
perpendicular.  Then you must enter the values of the digitized
points starting with the upper left, origin, lower right points.
Then you must enter the limits of the horizontal
axis and the limits of the vertical axis of your graph.
.PP
When the above is finished the program will return with "ENTER
POINTS FROM TABLET".  Now you can digitize points from
your graph.
.PP
If you somehow enter a point that is outside the limits of your
graph, the program will return with "POINT OUT OF BOUNDS".
You have various options at this point.  Type

.nf
.in 14n
r   to reenter the point.
    This will not affect the data count.

b   to begin entering the points again.
    This allows you to start over without
    having to reenter the limits etc.

w   when finished entering points. This
    will put you in the writing mode to
    write your data to a file.

x   will exit you from the program.
.in 0n
.fi

.PP
If you are finished entering points from the tablet, and wish to
write the data, digitize a point outside the graph.  The program
will return with "POINT OUT OF BOUNDS".  Type a

.in 14n
.B
w
.R
.in 0n

to write the data.
.PP
To write the data, the program will prompt you to enter the file
id of the file and record number where you want the data to be written.
Then you are prompted to type in the title of the data set that
will contain the x (horizontal) values, then after that the title
of the data set that contains the y (vertical) values. The data are
then written.
.PP
After all that you will be asked if you want to digitize another graph.
Answer yes or no, if no then the program exits.
