.\" use ms macros
.\" this header is for putting the page numbers at the bottom of the page
.\" set line length, page offset, vertical spacing
.nr LL 6.3i
.ll 6.3i
.nr PO 1.0i
.po 1.0i
.nr VS 12
.vs 12
.\" set header and footer margins (default is 1.0i)
.nr FM 1.00i
.fm 1.00i
.nr HM 1.00i
.hm 1.00i
.\" set no date here, MUST be before CF definition, because ND sets CF
.\" set date, so don't do .ND
.\" LH CH RH are left, center, right header strings
.\" LF CF RF are left, center, right footer strings
.\" default is CH is defined as: .ds CH "\(hy \\n(PN \(hy
.ds LH "SPECPR Users' Manual
.ds CH
.ds RH "Page 8-f20.\\n(PN
.\" setup complete
.nf
SPECPR Users' Manual                                            Page 8-f20.1


.B
F20:  Text File Input and Output                                 Alias: read
.R
.PP
Special Function 20 has two parts to it.  The first part reads data from a
text file (for example, one that was generated by any program or by
using the system editor).  The second part writes data from a specpr
file into a text file.
.PP
With both parts there are options to include
errors or wavelengths or both.  Data, errors, and wavelengths may be
written either in standard Fortran format 'f15.6' or in
exponential '1pe15.6' format, depending on the user's option.
The program works with one set of numbers per line i.e. wavelength, data
and errors.  Without the wavelength option, the order is data,
errors, and without the error option the order is wavelength, data
.PP
When writing the data to a specpr record (i.e v123), the
program will put the error values in the next consecutive specpr file
(i.e v124).

.B
Using Function 20
.R
.PP
To run function 20, type

.in 14n
.B
f20
.R
.in 0n

from math operations.  The routine
will prompt you for what part (reading or writing) you want to
do.  Type

.nf
.in 14n
r   for reading data,
re  for reading data and errors,
w   for writing 
we  for writing data and errors.
.in 0n
.fi

If you are writing to a text file,
you are given an option for format.  Type

.nf
.in 14n
f    for f format (Fortran format F15.6), or
e    for exponential format (Fortran 1pe15.6).
.in 0n
.fi

Next if you are writing, you are asked if
wavelengths are to be included.  Type

.nf
.in 14n
y          for yes to include wavelengths, and
<return>   or any other character for no.
.in 0n
.fi

Then you are instructed to enter the
filename of the text to which you will read or write data.
Currently, the file name must be 40 characters or less.
.PP
Be sure that when you are reading, the file is in
your directory, or you must give the full file name (i.e
/u/smith/dataf).
.PP
When reading, f20 will prompt you for
the starting column number where the data begins (e.g. col. 1 - 80).
Default is column one(1).  Columns are character columns, not
columns of numbers.  The routine does not count tabs properly, and
if a tab or control character is encountered, it is treated as an
error and the read is terminated.
.PP
After reading the data, you can exit normally to plot and write the
data, or elect to read the data again (type r to redo).
.PP
If you are writing data to a text file you
will be asked the file id and record number of the specpr file that
the data are from (v, w, d, u, or y).  When the operation is
finished you have the option to redo the operation or exit.
Type  r to redo the operation  at this point or e or x to exit.
You can thus write many text files without leaving f20.


.B
Setting Up the Text File
.R
.PP
There are two
ways of setting up a UNIX text file that can be read by f20.
.PP
First, and the easiest, is directed output.  Output the data to
the terminal and direct it to a file.  In your program write to
the terminal:

.nf
.in 10n
        write(6,10)data
 10     format(1x,1pe15.6)
.in 0n
.fi

or with errors

.nf
.in 10n
        write(6,10)data,error
 10     format(1x,1pe15.6,1pe15.6)
.in 0n
.fi

and run the program using this method

.in 10n
progname > filename
.in 0n

where progname is the program executable file and filename is the
file to be read by f20.
.PP
Second, you can write your data directly into a file.  You must
open the file and write to it.  See your local Fortran manual on how
to write ascii files.
.PP
When reading, enter f20 from math operations and when prompted
for your input/output filename, type in the filename of that
you assigned to the text file in the above examples.
The program will print out the channel number and the
data value of that channel.  The last channel number printed is
the number of channels in the file (or the number of data values
read by f20).

.B
An f20 Example (square the data and add 1.0)
.R

.nf
1) Operate on data using your own programs:

2) Put these values in v34 (with, for example the editor f14):

        channel 1: 0.99
                2: 0.90
                3: 0.70
                4: 0.40

3) Write v34 to file 'testa' using f20 and e format

4) Run program 'testprog <testa >testb'

5) Read testb into specpr using f20

6) List the 4 channels

Fortran program "testprog":

.in 20n
        program testprog
        real x,y
        do 100 i = 1, 4852
            read (5,1) x
1           format (1pe15.6)
c do a computation:
            y = x*x +1.0
            write (6,1) y
100     continue
        end
.in 0n
