.\" use ms macros
.\" this header is for putting the page numbers at the bottom of the page
.\" set line length, page offset, vertical spacing
.nr LL 6.3i
.ll 6.3i
.nr PO 1.0i
.po 1.0i
.nr VS 12
.vs 12
.\" set header and footer margins (default is 1.0i)
.nr FM 1.00i
.fm 1.00i
.nr HM 1.00i
.hm 1.00i
.\" set no date here, MUST be before CF definition, because ND sets CF
.\" set date, so don't do .ND
.\" LH CH RH are left, center, right header strings
.\" LF CF RF are left, center, right footer strings
.\" default is CH is defined as: .ds CH "\(hy \\n(PN \(hy
.ds LH "SPECPR Users' Manual
.ds CH
.ds RH "Page 8-f16.\\n(PN
.\" setup complete
.nf
SPECPR Users' Manual                                            Page 8-f16.1


.B
F16:  Line Segment Data Generator                           Alias: line[gen]
.R
.PP
This routine generates arrays of data by linearly interpolating user (x,y)
pairs to a wavelength set.
Given data values at specific wavelengths or channels typed in by
the user, this routine computes line segments between the points
the user has input.
.PP
Upon entering the routine, the user has the
option of changing the current wavelength set in use by typing
the file ID letter (upper case) and the record number, or assigning the channel
numbers as "wavelength values" with the maximum number of
channels given by the wavelength record.  To do this, type h and
the wavelength record number to assign channel numbers with the
number of channels given by the wavelength record number.  Examples:

.nf
.in 8n
V23      Assign wavelength data set in v23.
h482     Assign the array value = the wavelength data value.
         (channel 1 = 1.0, channel 2 = 2.0, ... channel 482 = 482.0).
C482     same as h482, but the wavelength routines assign the
         wavelength set before it is handed to the f16 routine.
<return> Use existing wavelength set in use.
.in 0n
.fi

.PP
After this initialization, the routine repeatedly asks for the first two
data values--the (x,y) coordinates for user point #1, then #2, etc.,
until you are through.  Enter the data
values separated by a space.  At each command point, a number of
control options can be entered:

.in 9n
.ti -9n
e or x   will cause the routine to exit.

.ti -9n
rn       return to step n, where n is the step number.
This allows the return to any previous input step so it may be changed
(and then you may return to the last step before you went to step n).
Note that you cannot change an x value (wavelength) to a value greater
than that in the next step--to do that, you must delete the following
steps.

.ti -9n
dn       delete steps.  Using this command, all data values after and
including step n will be deleted; command control returns to the
first step deleted.

.ti -9n
ln       is a list command which will list up to 25 entries previously
entered with the step number.  Here (n) is optional.  If it is
used, the routine lists from step number n to step n+24.

.ti -9n
b        for begin analysis.  The routine calculates all data values in the
array between each set of ordered pairs.
.in 0n

.PP
No input spectrum is required because you are creating data, not
operating on data.  If an input file was called, an error message
is printed, and the routine will hard exit.
.PP
All operations are checked for validity.  If a given operation
produces an error, a message will be printed stating what caused
the error and whether or not the routine can continue.  If it
can, the routine asks again for the data.  If not, the routine will exit,
hard or soft, depending on the severity of the condition.  Note
that all x data values (e.g. wavelengths) must be in increasing order, or error
messages will result.
