.\" use ms macros
.\" this header is for putting the page numbers at the bottom of the page
.\" set line length, page offset, vertical spacing
.nr LL 6.3i
.ll 6.3i
.nr PO 1.0i
.po 1.0i
.nr VS 12
.vs 12
.\" set header and footer margins (default is 1.0i)
.nr FM 1.00i
.fm 1.00i
.nr HM 1.00i
.hm 1.00i
.\" set no date here, MUST be before CF definition, because ND sets CF
.\" set date, so don't do .ND
.\" LH CH RH are left, center, right header strings
.\" LF CF RF are left, center, right footer strings
.\" default is CH is defined as: .ds CH "\(hy \\n(PN \(hy
.ds LH "SPECPR Users' Manual
.ds CH
.ds RH "Page 8-f14.\\n(PN
.\" setup complete
.nf
SPECPR Users' Manual                                            Page 8-f14.1


.B
F14:  Edits Spectral Data and Error Value                        Alias: edit
.R
.PP
This function allows editing of a data set and, if e is
specified at call time, its associated error set as well.

.PP
To call f14, specify the file and record number, f14, and, if errors
are desired, e.

Example:

.B
        v317f14e                    or               v317f14
.R

.PP
F14 accepts the following formatted commands to perform particular
tasks:

.in 8n
.nf
channel data/e error                            change
----------------------------------------------------------------
d[c] channel [channel1 t channel2] c          delete
i channel                                     insert after
l channel1 channel2                           list (crt)
pd                                            print data (lp)
c                                             continue
                                               (exit with write)
e                                             soft exit
x                                             hard exit
----------------------------------------------------------------
Note: both e and x terminate the editing session without
      writing the results.  Use "c" to exit and write results.
.fi
.in 0n

.PP
To CHANGE a data value (and its error, or just its error), specify
the channel number of the value to be changed and the new data
value (and the new error value); should you wish to change only the
error, specify the channel number, e, and the new error value. (If
you wish to change only the data value but you specified e at
call time, you must specify three parameters; the channel number,
the new data value, and the old error value.)  Incorrect or
uninterpretable format will cause an error message to be printed
on the terminal screen.  (Parameters may be entered either as
integers or as real numbers but not in exponential format.)

Examples:

.in 8n
.nf
Call setup  Command        Task enacted

v317f14    11 13.567    change channel 11 data value to 13.567
v317f14e   11 13.4 .2   change ch. 11 data to 13.4, error to .2
v317f14e   11 e .2      change ch. 11 error value to .2
v317f14e   11 13.567    ILLEGAL ENTRY (errors were specified at
                        call time, but no error value was entered)
.fi
.in 0n

.PP
To DELETE data values, specify d (or "dc" to delete and compress);
the routine will then accept only channel number or channel
ranges until the parameter c (do not confuse the parameter c with the option c)
is encountered, at which time the
delete task is performed.  Without option c, the data values of
all specified channels will be set to -1.23e+34 (the standard
value for SPECPR deleted points) [and the associated errors will
be set to 0.0].  However, if the dc command is specified, the
specified points will first be deleted, and then the channel
space will be compressed to totally eliminate the specified
channels.  (Note:  Compression of the channel space does not take
effect until all specified points have first been deleted.)
Channel numbers for the points to be deleted may be specified
either individually or as ranges; the character t specifies a
range of channels, starting with (and including) the number
preceding t, and ending with (and including) the number following
t, the command d, [the option c,] individual channels, channel
ranges, and the parameter c may all be strung together; spaces
are required as delimiters only between two numbers.

Examples:

.KS
.in 8n
.nf
Command                             Task enacted

d6 7 12t13 18t21c               Data values for channels 6, 7, 12,
                                13, 18, 19, 20, 21 are set to
                                -1.23e34:[errors for same channels
                                are set to 0.0]

dc1t3 7c                        channels 1, 2, 3, 7 are deleted
                                totally; old ch. 4 becomes new ch.
                                1; old ch. 5 becomes new 2; old 8
                                becomes new 4.

dc                              routine requests "enter more
                                deletions or type c to continue"
.fi
.in 0n
.KE

.PP
To INSERT data [and error] values after a specified channel,
specify i and the channel number after which you wish to insert
values.  (If no channel is specified, the routine defaults to
channel 0, in which case the insertions occur at the start of a
spectrum.)  The routine will then accept only data [and error]
values, one data [and error] value per line, until either a blank
line or two carriage returns in a row are encountered; either
integers or real numbers (but not exponential format) are
acceptable for data and errors.

Example:

.KS
.in 8n
.nf
Call setup    Command sequence         Task enacted
-----------------------------------------------------------------
v317f14e         i                routine prepares to accept data
                                  & errors, starting at channel 1

                 12 1.3           new channel 1: data = 12;
                                  error = 1.3; original ch. 1
                                  becomes new channel 2

                 15.6 .9          new channel 2: data = 15.6;
                                  error = .9; original ch.1
                                  becomes new channel 3

                 i2               routine prepares to accept data
                                  & errors starting after current
                                  channel 2

                16 2              new channel 3: data = 16;
                                  error = 2

                17.9              ILLEGAL ENTRY--no error was
                                  specified; routine requests last
                                  line to be retyped

                17.9 1.6          new channel 4: data = 17.9;
                                  error = 1.6; original ch.1 is
                                  now ch.5

               <return>           insertion routine stops
-----------------------------------------------------------------
.in 0n
.fi
.KE

.PP
To LIST data and error values on the terminal screen, specify l
and either a channel number or else two channel limits.  Data
[and error]  values will be listed in exponential format along
with channel numbers.  (Spaces are required as delimiters between
limits.)  All data values within the channel limits are listed
first; error values follow.

Example:

.KS
.in 8n
.nf
l 1 60    channel number & data value for channels 1 through
          60 are listed on the terminal [followed by channel
          number & error value for channels 1 through 60]

l 5       5 and data value for ch. 5 [and 5 and error value for
          ch. 5] are listed on the terminal
.fi
.in 0n
.KE

.PP
To PRINT the data [and error] values on the line printer, specify
pd.  The output format is the same as when pd is specified in the
CRT plot routine.
.PP
To CONTINUE normally and write the edited file, specify the
command c; the routine will exit to the write-to-file routine.
Note:  You cannot return to f14 and issue additional commands once
CONTINUE is enacted.)
.PP
A SOFT or HARD EXIT will occur if at any time the commands e or
x, respectively, are encountered; control will return to MATH
OPERATIONS.  (Exception:  In CHANGE, e is not interpreted as an
EXIT command if it follows a channel specification.)
.PP
.B
IMPORTANT NOTE:
.R
This routine does NOT record a history of the
edit commands performed; should you desire a record of your
editing commands, you must create a manual history yourself.
However, edited changes can be easily seen by comparing with the
original data set which is specified in the history.


Minor notes:
.PP
All channel numbers should be positive integers; if a real number
is entered by mistake, the routine will truncate it to integer
form.  All channel range limits must list the lower bound first
and the upper bound last.
.PP
If at any time during this routine you find yourself lost or
confused, try pressing <return> once or twice until the EDIT
COMMAND FORMAT message appears.  Alternatively, you may type e or
x to exit f14.
.PP
You may insert spaces as delimiters to improve the clarity of
commands; use of such spaces will not affect the operation of f14.
