.\" use ms macros
.\" this header is for putting the page numbers at the bottom of the page
.\" set line length, page offset, vertical spacing
.nr LL 6.3i
.ll 6.3i
.nr PO 1.0i
.po 1.0i
.nr VS 12
.vs 12
.\" set header and footer margins (default is 1.0i)
.nr FM 1.00i
.fm 1.00i
.nr HM 1.00i
.hm 1.00i
.\" set no date here, MUST be before CF definition, because ND sets CF
.\" set date, so don't do .ND
.\" LH CH RH are left, center, right header strings
.\" LF CF RF are left, center, right footer strings
.\" default is CH is defined as: .ds CH "\(hy \\n(PN \(hy
.ds LH "SPECPR Users' Manual
.ds CH
.ds RH "Page 3.\\n(PN
.\" setup complete
.nf
SPECPR Users' Manual                                                   Page 3.1













.ce
.B
CHAPTER 3
.R





.ce
.B
STARTING SPECPR
.R




.fi
.bp
.B
3.1  Starting Specpr on Unix
.R
.PP
To run specpr you must first log in to the system.  It is advisable
to do specpr work for a particular project in a separate directory.
Specpr uses protective locks on files to prevent simultaneous specpr
sessions from overwriting data.  Thus, if you are starting a new
project, create a directory in which to start, then cd to that
directory.

.PP
You can start specpr in one of five ways, using the following
commands.

.in 10n
.IP specpr 20
starts specpr, first with current messages, then a start "from
scratch" where a complete setup is required.  After the word
"specpr" type a carriage return.

.IP specpr\ rfile 20
starts specpr in restart mode, where the restart file "rfile"
contains all the information saved from the previous session.
Before specpr is started, current messages are displayed.

.KS
.IP specpr\ rfile\ -gN 20
starts specpr in restart mode, where the restart file "rfile"
contains all the information saved from the previous session.
The -gN option, where N is the graphics terminal type integer number
given in section 5.7, sets the graphics type as specpr is started.
The "N" may also be one of the strings "xterm" or "hpterm" (without
the quotes.  Thus the command "specpr rfile -gxterm" starts specpr
with restart file "rfile" and starts an xterm X-windows graphics
session.
.KE

.KS
.IP specpr\ rfile\ - 20
starts specpr in restart mode, where the restart file "rfile"
contains all the information saved from the previous session.  The
minus sign suppresses messages unless new messages have been added
since the last time "rfile" has been written.  After a basic setup,
this is the command you will want to use to restart specpr (or the
command below).
.KE

.KS
.IP specpr\ rfile\ -gN\ - 20
starts specpr in restart mode, where the restart file "rfile"
contains all the information saved from the previous session.
The -gN option, where N is the graphics terminal type integer number
given in section 5.7, sets the graphics type as specpr is started.
The "N" may also be one of the strings "xterm" or "hpterm" (without the
quotes.  The minus sign suppresses messages unless new messages have been
added since the last timer "rfile" has been written.  After a basic
setup, this is the command you will want to use to restart specpr
(especially when starting specpr from X-windows).  Thus the command
"specpr rfile -gxterm -" starts specpr with restart file "rfile" and
starts an xterm X-windows graphics session.
.KE


.in 0n
.PP
The restart file contains all information for restarting specpr and
putting it in the same state as when you last quit the
program.  Specpr periodically updates the restart file during a
processing session in case of a system or program crash.
.PP
The specpr startup messages are notes and information about changes, additions
and bugs in the current version of specpr.


.KS
.B
3.2  HELP!
.R
.PP
The user may get help at any keyboard input point in the program.
To get help, you simply type

.in 14n
.B
help
.R
.in 0n
or
.in 14n
.B
help <keyword>
.R
.in 0n

where "<keyword>" is a key word to search on.  The index of key
words and a description is displayed by just typing help.
.KE
.PP
Once in help, help is read with the Unix command defined by the
environment variable PAGER (see section 3.3), or if PAGER is not
defined, the Unix "more" command is used.  When reading help, if
there is more than one page you must follow the directions for that
Unix command (e.g. for the more command, press the space bar to get
to the next page or a "q" command to quit).  When you have completed
reading the index page or a keyword entry, the following message is
displayed:

.in 8n
-----------------------------------------
PRESS RETURN TO CONTINUE with program,
Type a keyword for help on that topic, or
Type  help  for the index page
-----------------------------------------
.in 0n

If you want to read about another keyword, simply type that key word
and press return.  If you want to redisplay the index pages, type
"help" (without the quotes) as the key word.

Example:  to get help on file protection at any point in specpr,
type

.in 14n
.B
help protection
.R
.in 0n

or, type

.in 14n
.B
help
.R
.in 0n

and once in the help facility, type the

.in 14n
.B
protection
.R
.in 0n

key word.


.KS
.B
3.3  Configuration of Environment Variables
.R
.PP
Specpr currently recognizes two environment variables.  An
environment variable is a variable that is set from the Unix
command line.  For example, in the c-shell, you type

.in 14n
setenv PAGER myprog
.in 0n

to set the environment variable PAGER.  See your local system
documentation on setting environment variables for other Unix
shells.
.KE
.PP
Commonly, users define these variables in the login startup files,
so they get activated each time the user logs in.
.PP
The environment variables currently used and defined by specpr are:

.in 12n
.ti -8n
PAGER  The program used for listing to the terminal screen.
Currently it is used by the help facility.  Default program if PAGER
is not defined is the Unix "more" command.

.ti -8n
EDITOR  The editor to use.  Currently, this is the editor to use
when editing specpr text records in the header information change
routines.  Default editor is "vi".

.in 0n
